/*
 * Decompiled with CFR 0.152.
 */
import fiji.util.gui.GenericDialogPlus;
import graphs.AlgorithmFlowEditor;
import graphs.ImageJCore;
import graphs.editor.MenuBar;
import graphs.model.MathType;
import graphs.model.ThresholdType;
import graphs.model.TopHatOp;
import ij.ImagePlus;
import ij.ImageStack;
import ij.plugin.ContrastEnhancer;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import io.scif.services.DatasetIOService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;
import net.imagej.Dataset;
import net.imagej.DefaultDataset;
import net.imagej.ImageJ;
import net.imagej.ImgPlus;
import net.imagej.display.ImageDisplayService;
import net.imagej.ops.OpService;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.type.numeric.RealType;
import ops.AverageFilter;
import ops.Binarize;
import ops.GaussianDifference;
import ops.HybridFilter;
import ops.MathFilter;
import ops.Normalize;
import ops.TophatImage;
import org.scijava.app.StatusService;
import org.scijava.command.Command;
import org.scijava.command.DynamicCommand;
import org.scijava.display.DisplayService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.thread.ThreadService;
import org.scijava.ui.UIService;

@Plugin(type=Command.class, menuPath="Plugins>Wound Healing Tool")
public class WoundHealing
extends DynamicCommand {
    private final String PLUGIN_NAME = "Wound Healing Tool 2";
    private final String USER_DIR = System.getProperty("user.home");
    private final String GITHUB_URL = "https://github.com/nurzhamanka/whiplugin";
    @Parameter
    private DatasetIOService datasetIOService;
    @Parameter
    private ImageDisplayService imageDisplayService;
    @Parameter
    private DisplayService displayService;
    @Parameter
    private OpService ops;
    @Parameter
    private LogService log;
    @Parameter
    private StatusService statusService;
    @Parameter
    private ThreadService thread;
    @Parameter
    private UIService ui;
    private Dataset activeDataset;
    private File inputDir;
    private File outputDir;
    private boolean isSaveBinMask;
    private boolean isOverwrite;
    private boolean isShowProcess;
    private AlgorithmFlowEditor graphEditor;

    public void run() {
        this.activeDataset = this.imageDisplayService.getActiveDataset();
        AtomicReference<Boolean> isGuiSelected = new AtomicReference<Boolean>(false);
        if (this.activeDataset != null) {
            GenericDialogPlus dialogActiveDataset = new GenericDialogPlus("Wound Healing Tool 2");
            dialogActiveDataset.addMessage("Choose a process");
            dialogActiveDataset.addButton("Launch GUI", e -> {
                isGuiSelected.set(true);
                dialogActiveDataset.dispose();
            });
            dialogActiveDataset.enableYesNoCancel("Process active dataset", "Process a directory");
            dialogActiveDataset.addHelp("https://github.com/nurzhamanka/whiplugin");
            dialogActiveDataset.showDialog();
            if (dialogActiveDataset.wasOKed()) {
                this.populateParams(false);
                if (this.isCanceled()) {
                    return;
                }
                this.processActiveDataset();
            } else if (dialogActiveDataset.wasCanceled()) {
                this.cancel();
            } else if (!isGuiSelected.get().booleanValue()) {
                this.populateParams(true);
                if (this.isCanceled()) {
                    return;
                }
                this.processDirectory();
            } else {
                this.launchGUI();
            }
        } else {
            GenericDialogPlus dialogActiveDataset = new GenericDialogPlus("Wound Healing Tool 2");
            dialogActiveDataset.addMessage("Choose a process");
            dialogActiveDataset.enableYesNoCancel("Launch GUI", "Process a directory");
            dialogActiveDataset.addHelp("https://github.com/nurzhamanka/whiplugin");
            dialogActiveDataset.showDialog();
            if (dialogActiveDataset.wasOKed()) {
                this.launchGUI();
            } else if (dialogActiveDataset.wasCanceled()) {
                this.cancel();
            } else {
                this.populateParams(true);
                if (this.isCanceled()) {
                    return;
                }
                this.processDirectory();
            }
        }
    }

    private void launchGUI() {
        this.log.info((Object)"GUI launched!");
        SwingUtilities.invokeLater(() -> {
            if (this.graphEditor == null) {
                ImageJCore core = new ImageJCore();
                core.setDatasetIOService(this.datasetIOService);
                core.setDisplayService(this.displayService);
                core.setImageDisplayService(this.imageDisplayService);
                core.setLog(this.log);
                core.setOps(this.ops);
                core.setStatusService(this.statusService);
                core.setThread(this.thread);
                core.setUi(this.ui);
                this.graphEditor = new AlgorithmFlowEditor(core);
                this.graphEditor.createFrame(new MenuBar(this.graphEditor)).setVisible(true);
            }
        });
    }

    private void populateParams(boolean hasDirectory) {
        GenericDialogPlus dialogParams = new GenericDialogPlus("Wound Healing Tool 2");
        dialogParams.addMessage("Welcome to Wound Healing Tool 2. Please specify the parameters.");
        if (hasDirectory) {
            dialogParams.addDirectoryField("Input root path", this.USER_DIR);
            dialogParams.addDirectoryField("Output root path", this.USER_DIR);
            dialogParams.addCheckbox("Save binary masks", true);
            dialogParams.addMessage("If checked, already processed images will be overwritten. \nUncheck if you want to resume an aborted process.");
            dialogParams.addCheckbox("Overwrite processed data", true);
        }
        dialogParams.addMessage("If checked, a separate stack showing the pipeline's steps will be produced.");
        dialogParams.addCheckbox("Produce a process stack?", true);
        dialogParams.addHelp("https://github.com/nurzhamanka/whiplugin");
        dialogParams.showDialog();
        if (dialogParams.wasOKed()) {
            if (hasDirectory) {
                this.inputDir = new File(dialogParams.getNextString());
                this.outputDir = new File(dialogParams.getNextString());
                if (!this.inputDir.isDirectory() || !this.outputDir.isDirectory()) {
                    this.cancel("Input and output paths must be directories");
                    return;
                }
                if (this.inputDir.equals(this.outputDir)) {
                    this.cancel("Input and output paths must be different directories");
                    return;
                }
                this.isSaveBinMask = dialogParams.getNextBoolean();
                this.isOverwrite = dialogParams.getNextBoolean();
            }
            this.isShowProcess = dialogParams.getNextBoolean();
        } else {
            this.cancel("Plugin canceled by user");
        }
    }

    private <T extends RealType<T>> void processActiveDataset() {
        ImagePlus processImage;
        ImagePlus activeImagePlus = ImageJFunctions.wrap((RandomAccessibleInterval)this.activeDataset.getImgPlus().getImg(), (String)"Active dataset");
        if (activeImagePlus.isStack() || activeImagePlus.isHyperStack()) {
            this.log.info((Object)"Active dataset is a stack...");
            ImageStack processStack = new ImageStack(activeImagePlus.getWidth(), activeImagePlus.getHeight());
            ImageStack stack = activeImagePlus.getStack();
            int stackSize = stack.getSize();
            for (int i = 1; i <= stackSize; ++i) {
                this.statusService.showStatus("Processing the active dataset... (" + i + "/" + stackSize + ")");
                this.statusService.showProgress(i - 1, stackSize);
                Img sliceImg = ImageJFunctions.wrapReal((ImagePlus)new ImagePlus("Slice " + i, stack.getProcessor(i)));
                Img<T> sliceImgProcessed = this.process(sliceImg);
                ImageProcessor ip = ImageJFunctions.wrap(sliceImgProcessed, (String)("Slice " + i + " processed")).getProcessor();
                processStack.addSlice("Slice " + i, ip);
            }
            this.statusService.showProgress(stackSize, stackSize);
            processImage = new ImagePlus(this.activeDataset.getName() + " (processed)", processStack);
        } else {
            this.log.info((Object)"Active dataset is a single image...");
            this.statusService.showStatus("Processing the active dataset...");
            Dataset processedDataset = this.process(this.activeDataset);
            processImage = ImageJFunctions.wrap((RandomAccessibleInterval)processedDataset.getImgPlus().getImg(), (String)(this.activeDataset.getName() + " (processed)"));
        }
        this.statusService.showStatus("Displaying the result...");
        processImage.show();
    }

    private void processDirectory() {
        assert (this.inputDir.isDirectory());
        File[] sets = this.inputDir.listFiles(File::isDirectory);
        assert (sets != null);
        if (sets.length == 0) {
            this.cancel("The dataset is empty");
            return;
        }
        int currentSetNumber = 1;
        for (File set : sets) {
            assert (set.isDirectory());
            File saveDir = new File(this.outputDir.getAbsolutePath() + File.separator + set.getName());
            this.log.info((Object)("CURRENT DIR: " + saveDir.getAbsolutePath()));
            if (!saveDir.mkdir()) {
                this.log.info((Object)("Could not create " + saveDir.getAbsolutePath()));
                if (saveDir.exists()) {
                    this.log.info((Object)"--- this directory exists");
                } else {
                    this.log.error((Object)"--- something went wrong, moving on to the next dataset...");
                    continue;
                }
            }
            this.statusService.showStatus("Processing:" + set.getName() + " (" + currentSetNumber + "/" + sets.length + ")");
            File[] inputImages = set.listFiles(pathname -> !pathname.getAbsolutePath().contains(".DS_Store") && this.datasetIOService.canOpen(pathname.getAbsolutePath()));
            assert (inputImages != null);
            if (inputImages.length == 0) continue;
            ArrayList<Long> times = new ArrayList<Long>();
            int currentImageNumber = 0;
            for (File image : inputImages) {
                long startTime;
                block17: {
                    Dataset currentImage;
                    File imgFile = new File(saveDir.getAbsolutePath() + File.separator + image.getName());
                    if (!this.isOverwrite && imgFile.exists()) {
                        this.log.info((Object)("Image " + imgFile.getName() + " has been processed - skipping..."));
                        continue;
                    }
                    if ((currentImageNumber + 1) % 3 == 0) {
                        ++currentImageNumber;
                        continue;
                    }
                    this.statusService.showProgress(currentImageNumber, inputImages.length);
                    startTime = System.currentTimeMillis();
                    this.log.info((Object)("Processing " + image.getName()));
                    String imgPath = image.getAbsolutePath();
                    try {
                        currentImage = this.datasetIOService.open(imgPath);
                    }
                    catch (IOException e) {
                        this.log.error((Throwable)e);
                        continue;
                    }
                    Dataset result = this.process(currentImage);
                    if (this.isSaveBinMask) {
                        try {
                            this.datasetIOService.save(result, saveDir.getAbsolutePath() + File.separator + image.getName());
                            break block17;
                        }
                        catch (IOException e) {
                            this.log.error((Throwable)e);
                            continue;
                        }
                    }
                    this.displayService.createDisplay(currentImage.getName() + " (original)", (Object)currentImage);
                    this.displayService.createDisplay(currentImage.getName() + " (processed)", (Object)result);
                }
                long endTime = System.currentTimeMillis();
                long fd = endTime - startTime;
                this.log.info((Object)(image.getName() + " saved. It took " + (double)fd / 1000.0 + "s."));
                times.add(fd);
                ++currentImageNumber;
            }
            double sum = times.stream().mapToDouble(val -> val.longValue()).sum();
            double average = times.stream().mapToDouble(val -> val.longValue()).average().orElse(0.0);
            this.log.info((Object)("Dataset processed in " + sum / 1000.0 + "s."));
            this.log.info((Object)("Average time per image is " + average / 1000.0 + "s."));
            ++currentSetNumber;
        }
    }

    private Dataset process(Dataset dataset) {
        Img result = this.process(dataset.getImgPlus().getImg());
        return new DefaultDataset(dataset.context(), new ImgPlus(result));
    }

    private <T extends RealType<T>> Img<T> process(Img<T> image) {
        ImageStack processStack = null;
        if (this.isShowProcess) {
            processStack = new ImageStack((int)image.dimension(0), (int)image.dimension(1));
        }
        this.statusService.showStatus(0, 8, "Normalizing image...");
        Img img = this.ops.convert().float64(image);
        img = (Img)this.ops.run(Normalize.class, new Object[]{img, 0.0, 1.0});
        if (processStack != null) {
            processStack.addSlice("1. Original Image", this.makeSlice(img));
        }
        this.statusService.showStatus(1, 8, "Stretching histogram...");
        img = (Img)this.ops.run(MathFilter.class, new Object[]{img, MathType.SQUARE, 2.0});
        if (processStack != null) {
            processStack.addSlice("2. Squared Image", this.makeSlice(img));
        }
        this.statusService.showStatus(2, 8, "Bandpass Filtering...");
        img = (Img)this.ops.run(Normalize.class, new Object[]{img, 0.0, 1.0});
        img = (Img)this.ops.run(GaussianDifference.class, new Object[]{img, 2.0, 1.0});
        if (processStack != null) {
            processStack.addSlice("3. DoG", this.makeSlice(img));
        }
        this.statusService.showStatus(3, 8, "Gradient Denoising...");
        img = (Img)this.ops.run(Normalize.class, new Object[]{img, 0.0, 1.0});
        img = (Img)this.ops.run(HybridFilter.class, new Object[]{img, 9});
        if (processStack != null) {
            processStack.addSlice("4. Hybrid Filter", this.makeSlice(img));
        }
        this.statusService.showStatus(4, 8, "Morphological Filtering...");
        img = (Img)this.ops.run(Normalize.class, new Object[]{img, 0.0, 1.0});
        img = (Img)this.ops.run(TophatImage.class, new Object[]{img, TopHatOp.ThType.WHITE, TopHatOp.Shape.DISK, 6});
        if (processStack != null) {
            processStack.addSlice("5. Top Hat", this.makeSlice(img));
        }
        this.statusService.showStatus(5, 8, "Smoothing image...");
        img = (Img)this.ops.run(Normalize.class, new Object[]{img, 0.0, 1.0});
        img = (Img)this.ops.run(AverageFilter.class, new Object[]{img, 19});
        if (processStack != null) {
            processStack.addSlice("6. Mean Smoothing", this.makeSlice(img));
        }
        this.statusService.showStatus(6, 8, "Binarizing image...");
        img = (Img)this.ops.run(Normalize.class, new Object[]{img, 0.0, 1.0});
        Img binImg = (Img)this.ops.run(Binarize.class, new Object[]{img, ThresholdType.MEAN, Math.PI, true});
        img = this.ops.convert().float64((IterableInterval)binImg);
        if (processStack != null) {
            processStack.addSlice("7. Binary Mask", this.makeSlice(img));
        }
        if (processStack != null) {
            this.statusService.showStatus(7, 8, "Building the process stack...");
            ImagePlus processImage = new ImagePlus("Process", processStack);
            ContrastEnhancer ch = new ContrastEnhancer();
            for (int i = 1; i <= processImage.getStack().getSize(); ++i) {
                ByteProcessor ip = processImage.getStack().getProcessor(i).convertToByteProcessor();
                ch.equalize((ImageProcessor)ip);
            }
            processImage.show();
        }
        this.statusService.showStatus(8, 8, "Finishing up...");
        img = (Img)this.ops.run(Normalize.class, new Object[]{img, 0, 255});
        return this.ops.convert().uint8((IterableInterval)img);
    }

    private ImageProcessor makeSlice(Img img) {
        ImageProcessor ip = ImageJFunctions.wrap((RandomAccessibleInterval)img, (String)"").getProcessor();
        ip.convertToByte(true);
        return ip;
    }

    public static void main(String ... args) throws Exception {
        ImageJ ij = new ImageJ();
        ij.launch(args);
        ij.command().run(WoundHealing.class, true, new Object[0]);
    }
}

