/*
 * Decompiled with CFR 0.152.
 */
package graphs.editor;

import com.mxgraph.layout.hierarchical.mxHierarchicalLayout;
import com.mxgraph.layout.mxIGraphLayout;
import com.mxgraph.swing.handler.mxKeyboardHandler;
import com.mxgraph.swing.handler.mxRubberband;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.mxGraphOutline;
import com.mxgraph.swing.util.mxMorphing;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUndoManager;
import com.mxgraph.util.mxUndoableEdit;
import com.mxgraph.view.mxGraph;
import graphs.editor.KeyboardHandler;
import graphs.editor.Palette;
import graphs.editor.PopupMenu;
import graphs.editor.ToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class GraphEditor
extends JPanel {
    private static final long serialVersionUID = -6561623072112577140L;
    protected mxGraphComponent graphComponent;
    protected JTabbedPane libraryPane;
    protected mxUndoManager undoManager;
    protected String appTitle;
    protected JLabel statusBar;
    protected File currentFile;
    protected boolean modified = false;
    protected mxRubberband rubberband;
    protected mxKeyboardHandler keyboardHandler;
    protected mxEventSource.mxIEventListener undoHandler = (source, evt) -> this.undoManager.undoableEditHappened((mxUndoableEdit)evt.getProperty("edit"));
    protected mxEventSource.mxIEventListener changeTracker = (source, evt) -> this.setModified(true);

    public GraphEditor(String appTitle, mxGraphComponent component) {
        this.appTitle = appTitle;
        this.graphComponent = component;
        this.graphComponent.setAutoExtend(true);
        mxGraph graph = this.graphComponent.getGraph();
        this.undoManager = this.createUndoManager();
        graph.setResetViewOnRootChange(false);
        graph.getModel().addListener("change", this.changeTracker);
        graph.getModel().addListener("undo", this.undoHandler);
        graph.getView().addListener("undo", this.undoHandler);
        mxEventSource.mxIEventListener undoHandler = (source, evt) -> {
            List changes = ((mxUndoableEdit)evt.getProperty("edit")).getChanges();
            graph.setSelectionCells(graph.getSelectionCellsForChanges(changes));
        };
        this.undoManager.addListener("undo", undoHandler);
        this.undoManager.addListener("redo", undoHandler);
        this.libraryPane = new JTabbedPane();
        JSplitPane outer = new JSplitPane(1, this.libraryPane, (Component)this.graphComponent);
        outer.setOneTouchExpandable(true);
        outer.setDividerLocation(200);
        outer.setDividerSize(6);
        outer.setBorder(null);
        this.statusBar = this.createStatusBar();
        this.installRepaintListener();
        this.setLayout(new BorderLayout());
        this.add((Component)outer, "Center");
        this.add((Component)this.statusBar, "South");
        this.installToolBar();
        this.installHandlers();
        this.installListeners();
        this.updateTitle();
    }

    protected mxUndoManager createUndoManager() {
        return new mxUndoManager();
    }

    protected void installHandlers() {
        this.rubberband = new mxRubberband(this.graphComponent);
        this.keyboardHandler = new KeyboardHandler(this.graphComponent);
    }

    protected void installToolBar() {
        this.add((Component)new ToolBar(this, 0), "North");
    }

    protected JLabel createStatusBar() {
        JLabel statusBar = new JLabel("Ready");
        statusBar.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        return statusBar;
    }

    protected void installRepaintListener() {
        this.graphComponent.getGraph().addListener("repaint", (source, evt) -> {
            String buffer = this.graphComponent.getTripleBuffer() != null ? "" : " (unbuffered)";
            mxRectangle dirty = (mxRectangle)evt.getProperty("region");
            if (dirty == null) {
                this.status("Repaint all" + buffer);
            } else {
                this.status("Repaint: x=" + (int)dirty.getX() + " y=" + (int)dirty.getY() + " w=" + (int)dirty.getWidth() + " h=" + (int)dirty.getHeight() + buffer);
            }
        });
    }

    public Palette insertPalette(String title) {
        final Palette palette = new Palette();
        final JScrollPane scrollPane = new JScrollPane(palette);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setHorizontalScrollBarPolicy(31);
        this.libraryPane.add(title, scrollPane);
        this.libraryPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int w = scrollPane.getWidth() - scrollPane.getVerticalScrollBar().getWidth();
                palette.setPreferredWidth(w);
            }
        });
        return palette;
    }

    protected void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getWheelRotation() < 0) {
            this.graphComponent.zoomIn();
        } else {
            this.graphComponent.zoomOut();
        }
        this.status("Scale: " + (int)(100.0 * this.graphComponent.getGraph().getView().getScale()) + "%");
    }

    protected void showGraphPopupMenu(MouseEvent e) {
        Point pt = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), (Component)this.graphComponent);
        PopupMenu menu = new PopupMenu(this);
        menu.show((Component)this.graphComponent, pt.x, pt.y);
        e.consume();
    }

    protected void mouseLocationChanged(MouseEvent e) {
        this.status(e.getX() + ", " + e.getY());
    }

    protected void installListeners() {
        this.graphComponent.addMouseWheelListener(e -> {
            if (e.getSource() instanceof mxGraphOutline || e.isControlDown()) {
                this.mouseWheelMoved(e);
            }
        });
        this.graphComponent.getGraphControl().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.mouseReleased(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    GraphEditor.this.showGraphPopupMenu(e);
                }
            }
        });
        this.graphComponent.getGraphControl().addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                GraphEditor.this.mouseLocationChanged(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                this.mouseDragged(e);
            }
        });
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    public void setCurrentFile(File file) {
        File oldValue = this.currentFile;
        this.currentFile = file;
        this.firePropertyChange("currentFile", oldValue, file);
        if (oldValue != file) {
            this.updateTitle();
        }
    }

    public boolean isNotModified() {
        return !this.modified;
    }

    public void setModified(boolean modified) {
        boolean oldValue = this.modified;
        this.modified = modified;
        this.firePropertyChange("modified", oldValue, modified);
        if (oldValue != modified) {
            this.updateTitle();
        }
    }

    public mxGraphComponent getGraphComponent() {
        return this.graphComponent;
    }

    public JTabbedPane getLibraryPane() {
        return this.libraryPane;
    }

    public mxUndoManager getUndoManager() {
        return this.undoManager;
    }

    public Action bind(String name, final Action action) {
        AbstractAction newAction = new AbstractAction(name){

            @Override
            public void actionPerformed(ActionEvent e) {
                action.actionPerformed(new ActionEvent(GraphEditor.this.getGraphComponent(), e.getID(), e.getActionCommand()));
            }
        };
        newAction.putValue("ShortDescription", action.getValue("ShortDescription"));
        return newAction;
    }

    public void status(String msg) {
        this.statusBar.setText(msg);
    }

    public void updateTitle() {
        JFrame frame = (JFrame)SwingUtilities.windowForComponent(this);
        if (frame != null) {
            String title;
            String string = title = this.currentFile != null ? this.currentFile.getAbsolutePath() : "New Pipeline";
            if (this.modified) {
                title = title + "*";
            }
            frame.setTitle(title + " - " + this.appTitle);
        }
    }

    public void exit() {
        JFrame frame = (JFrame)SwingUtilities.windowForComponent(this);
        if (frame != null) {
            frame.dispose();
        }
    }

    public void setLookAndFeel(String clazz) {
        JFrame frame = (JFrame)SwingUtilities.windowForComponent(this);
        if (frame != null) {
            try {
                UIManager.setLookAndFeel(clazz);
                SwingUtilities.updateComponentTreeUI(frame);
                this.keyboardHandler = new KeyboardHandler(this.graphComponent);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public JFrame createFrame(JMenuBar menuBar) {
        JFrame frame = new JFrame();
        frame.getContentPane().add(this);
        frame.setDefaultCloseOperation(3);
        frame.setJMenuBar(menuBar);
        frame.setSize(870, 640);
        this.updateTitle();
        return frame;
    }

    public Action graphLayout(String key, boolean animate) {
        final mxIGraphLayout layout = this.createLayout(key, animate);
        if (layout != null) {
            return new AbstractAction(key){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    mxGraph graph = GraphEditor.this.graphComponent.getGraph();
                    Object cell = graph.getSelectionCell();
                    if (cell == null || graph.getModel().getChildCount(cell) == 0) {
                        cell = graph.getDefaultParent();
                    }
                    graph.getModel().beginUpdate();
                    try {
                        long t0 = System.currentTimeMillis();
                        layout.execute(cell);
                        GraphEditor.this.status("Layout: " + (System.currentTimeMillis() - t0) + " ms");
                    }
                    finally {
                        mxMorphing morph = new mxMorphing(GraphEditor.this.graphComponent, 20, 1.2, 20);
                        morph.addListener("done", (sender, evt) -> graph.getModel().endUpdate());
                        morph.startAnimation();
                    }
                }
            };
        }
        return new AbstractAction(key){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog((Component)GraphEditor.this.graphComponent, "No Layout");
            }
        };
    }

    protected mxIGraphLayout createLayout(String ident, boolean animate) {
        mxHierarchicalLayout layout = null;
        if (ident != null) {
            mxGraph graph = this.graphComponent.getGraph();
            switch (ident) {
                case "Beautify (Vertical)": {
                    layout = new mxHierarchicalLayout(graph);
                    break;
                }
                case "Beautify (Horizontal)": {
                    layout = new mxHierarchicalLayout(graph, 7);
                }
            }
        }
        return layout;
    }
}

