/*
 * Decompiled with CFR 0.152.
 */
package graphs.model;

import graphs.model.OpType;
import graphs.model.Operation;
import graphs.model.ThresholdType;
import java.util.Map;

public class BinarizeOp
extends Operation {
    private ThresholdType threshType = ThresholdType.MEAN;
    private Double denominator = Math.PI;
    private Boolean doParticleAnalysis = false;

    public BinarizeOp() {
        super("Binarize", OpType.BINARIZE);
    }

    public ThresholdType getThreshType() {
        return this.threshType;
    }

    public void setThreshType(ThresholdType threshType) {
        this.threshType = threshType;
    }

    public Double getDenominator() {
        return this.denominator;
    }

    public void setDenominator(Double denominator) {
        this.denominator = denominator;
    }

    public Boolean getDoParticleAnalysis() {
        return this.doParticleAnalysis;
    }

    public void setDoParticleAnalysis(Boolean doParticleAnalysis) {
        this.doParticleAnalysis = doParticleAnalysis;
    }

    @Override
    public Map<String, String> getKeyValuePairs() {
        Map<String, String> map = super.getKeyValuePairs();
        map.put("threshType", String.valueOf(this.threshType.toString()));
        map.put("denominator", String.valueOf(this.denominator));
        map.put("doParticleAnalysis", String.valueOf(this.doParticleAnalysis));
        return map;
    }

    @Override
    public String toString() {
        if (this.threshType == ThresholdType.MEAN || this.threshType == ThresholdType.MEDIAN) {
            return String.format("%s\nt = %s/%.4f\n%s", super.toString(), this.threshType.toString(), this.denominator, this.doParticleAnalysis);
        }
        return String.format("%s\nt = %s\n%s", super.toString(), this.threshType.toString(), this.doParticleAnalysis);
    }
}

