/*
 * Decompiled with CFR 0.152.
 */
package ops;

import ij.ImagePlus;
import ij.plugin.filter.RankFilters;
import ij.process.ImageProcessor;
import net.imagej.ops.AbstractOp;
import net.imagej.ops.Op;
import net.imagej.ops.OpService;
import net.imglib2.IterableInterval;
import net.imglib2.img.Img;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.type.numeric.RealType;
import org.scijava.ItemIO;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Op.class, name="denoiser")
public class AdaptiveDenoiser<T extends RealType<T>>
extends AbstractOp {
    @Parameter(type=ItemIO.INPUT)
    private Img<T> inImg;
    @Parameter(type=ItemIO.INPUT)
    private double radius;
    @Parameter(type=ItemIO.INPUT)
    private int threshold;
    @Parameter(type=ItemIO.OUTPUT)
    private Img<T> outImg;
    @Parameter
    private LogService log;
    @Parameter
    private OpService ops;

    public void run() {
        this.log.info((Object)("Adaptive Denoiser, radius " + this.radius + ", threshold " + this.threshold + "..."));
        long startTime = System.currentTimeMillis();
        ImagePlus imp = ImageJFunctions.wrapFloat(this.inImg, (String)"Input Image");
        ImageProcessor ip = imp.getProcessor();
        RankFilters rf = new RankFilters();
        rf.setup("outliers", imp);
        rf.rank(ip, this.radius, 5, 0, (float)this.threshold);
        this.log.info((Object)"--- outlier blobs weeded out");
        Img img = ImageJFunctions.wrapReal((ImagePlus)new ImagePlus("Denoised (Clean)", ip));
        this.outImg = this.ops.convert().float64((IterableInterval)img);
        long endTime = System.currentTimeMillis();
        long fd = endTime - startTime;
        this.log.info((Object)("--- time: " + (double)fd / 1000.0 + "s."));
    }
}

