/*
 * Decompiled with CFR 0.152.
 */
package ops;

import net.imagej.ops.AbstractOp;
import net.imagej.ops.Op;
import net.imagej.ops.OpService;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.real.AbstractRealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.ItemIO;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Op.class, name="average")
public class AverageFilter
extends AbstractOp {
    @Parameter(type=ItemIO.INPUT)
    private Img<DoubleType> inImg;
    @Parameter(type=ItemIO.INPUT)
    private long kernelSize;
    @Parameter(type=ItemIO.OUTPUT)
    private Img<DoubleType> outImg;
    @Parameter
    private OpService ops;
    @Parameter
    private LogService log;

    public void run() {
        this.log.info((Object)"Mean Smoothing...");
        long startTime = System.currentTimeMillis();
        long[] kernelDims = new long[]{this.kernelSize, this.kernelSize};
        Img<DoubleType> kernel = Helper.getKernel(kernelDims);
        this.outImg = (Img)this.ops.filter().convolve(this.inImg, kernel);
        long endTime = System.currentTimeMillis();
        long fd = endTime - startTime;
        this.log.info((Object)("--- time: " + (double)fd / 1000.0 + "s."));
    }

    private static class Helper {
        private static final ImgFactory<DoubleType> imgFactory = new ArrayImgFactory((NativeType)new DoubleType());
        private static Img<DoubleType> kernel;

        private Helper() {
        }

        static Img<DoubleType> getKernel(long[] kernelDims) {
            if (kernel != null) {
                return kernel;
            }
            kernel = imgFactory.create(kernelDims);
            kernel.forEach(AbstractRealType::inc);
            return kernel;
        }
    }
}

