/*
 * Decompiled with CFR 0.152.
 */
package ops;

import net.imagej.ops.AbstractOp;
import net.imagej.ops.Op;
import net.imagej.ops.OpService;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.ImgView;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.ItemIO;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Op.class, name="hybrid")
public class HybridFilter
extends AbstractOp {
    @Parameter(type=ItemIO.INPUT)
    private Img<DoubleType> inImg;
    @Parameter(type=ItemIO.INPUT)
    private long kernelSize;
    @Parameter(type=ItemIO.OUTPUT)
    private Img<DoubleType> outImg;
    @Parameter
    private OpService ops;
    @Parameter
    private LogService log;

    public void run() {
        this.log.info((Object)("Denoising Hybrid Filter, kernel size [" + this.kernelSize + "x" + this.kernelSize + "]..."));
        long startTime = System.currentTimeMillis();
        if (this.kernelSize % 4L != 1L) {
            this.log.error((Throwable)new Exception("Kernel size must be of the form 4k+1."));
        }
        this.outImg = this.inImg.factory().create(this.inImg);
        long[] imageDims = new long[]{this.inImg.dimension(0), this.inImg.dimension(1)};
        long[] kernelDims = new long[]{this.kernelSize, this.kernelSize};
        Img[] avgs = new Img[4];
        RandomAccess[] ras = new RandomAccess[4];
        for (int i = 0; i < 4; ++i) {
            this.log.info((Object)("--- convolution #" + (i + 1)));
            avgs[i] = (Img)this.ops.filter().convolve(this.inImg, Helper.getKernel(i, kernelDims, this.kernelSize, this.ops));
            ras[i] = avgs[i].randomAccess();
        }
        this.log.info((Object)"--- final image construction");
        RandomAccess outRa = this.outImg.randomAccess();
        for (long i = 0L; i < imageDims[0]; ++i) {
            for (long j = 0L; j < imageDims[1]; ++j) {
                long[] pos = new long[]{i, j};
                for (RandomAccess ra : ras) {
                    ra.setPosition(pos);
                }
                outRa.setPosition(pos);
                ((DoubleType)outRa.get()).set(Math.min(Math.min(((DoubleType)ras[0].get()).get(), ((DoubleType)ras[1].get()).get()), Math.min(((DoubleType)ras[2].get()).get(), ((DoubleType)ras[3].get()).get())));
            }
        }
        long endTime = System.currentTimeMillis();
        long fd = endTime - startTime;
        this.log.info((Object)("--- time: " + (double)fd / 1000.0 + "s."));
    }

    private static class Helper {
        private static Img<DoubleType>[] avgker;

        private Helper() {
        }

        static Img<DoubleType> getKernel(int n, long[] kernelDims, long winSize, OpService ops) {
            if (avgker == null) {
                ArrayImgFactory imgFactory = new ArrayImgFactory((NativeType)new DoubleType());
                avgker = new Img[4];
                Helper.avgker[0] = imgFactory.create(kernelDims);
                RandomAccess nwRa = avgker[0].randomAccess();
                long i = 0L;
                while (i < winSize) {
                    long[] pos = new long[]{i++, winSize / 2L};
                    nwRa.setPosition(pos);
                    ((DoubleType)nwRa.get()).set(1.0);
                }
                Helper.avgker[1] = ImgView.wrap((RandomAccessibleInterval)ops.transform().rotateView(avgker[0], 1, 0), (ImgFactory)avgker[0].factory());
                Helper.avgker[2] = imgFactory.create(kernelDims);
                RandomAccess seRa = avgker[2].randomAccess();
                long i2 = 0L;
                while (i2 < winSize) {
                    long[] pos = new long[]{i2, i2++};
                    seRa.setPosition(pos);
                    ((DoubleType)seRa.get()).set(1.0);
                }
                Helper.avgker[3] = ImgView.wrap((RandomAccessibleInterval)ops.transform().rotateView(avgker[0], 1, 0), (ImgFactory)avgker[2].factory());
            }
            return avgker[n];
        }
    }
}

