/*
 * Decompiled with CFR 0.152.
 */
package ops;

import java.util.Arrays;
import net.imagej.ops.AbstractOp;
import net.imagej.ops.Op;
import net.imagej.ops.OpService;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.RectangleShape;
import net.imglib2.img.Img;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.outofbounds.OutOfBoundsMirrorFactory;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.scijava.ItemIO;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.UIService;

@Plugin(type=Op.class, name="median")
public class MedianFilter
extends AbstractOp {
    @Parameter(type=ItemIO.INPUT)
    private Img<DoubleType> inImg;
    @Parameter(type=ItemIO.INPUT)
    private int kernelSize;
    @Parameter(type=ItemIO.OUTPUT)
    private Img<DoubleType> outImg;
    @Parameter
    private OpService ops;
    @Parameter
    private LogService log;
    @Parameter
    private UIService ui;

    public void run() {
        this.log.info((Object)("Median Filter, kernel size [" + this.kernelSize + "x" + this.kernelSize + "]..."));
        long startTime = System.currentTimeMillis();
        if (this.kernelSize % 2 != 1) {
            this.log.error((Throwable)new Exception("Kernel size must be of the form 2k+1."));
        }
        this.outImg = this.inImg.factory().create(this.inImg);
        RectangleShape shape = new RectangleShape((this.kernelSize - 1) / 2, false);
        IntervalView paddedImg = Views.interval((RandomAccessible)new ExtendedRandomAccessibleInterval(this.inImg, (OutOfBoundsFactory)new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE)), this.inImg);
        RandomAccess inRa = paddedImg.randomAccess();
        RandomAccess outRa = this.outImg.randomAccess();
        RectangleShape.NeighborhoodsIterableInterval neighborhoods = shape.neighborhoods((RandomAccessibleInterval)paddedImg);
        for (Neighborhood neighborhood : neighborhoods) {
            inRa.setPosition((Localizable)neighborhood);
            outRa.setPosition((Localizable)inRa);
            double[] vals = new double[this.kernelSize * this.kernelSize];
            int i = 0;
            for (DoubleType value : neighborhood) {
                vals[i] = value.get();
                ++i;
            }
            Arrays.sort(vals);
            double median = vals[(this.kernelSize * this.kernelSize - 1) / 2];
            ((DoubleType)outRa.get()).set(median);
        }
        long endTime = System.currentTimeMillis();
        long fd = endTime - startTime;
        this.log.info((Object)("--- time: " + (double)fd / 1000.0 + "s."));
    }
}

