/*
 * Decompiled with CFR 0.152.
 */
package ops;

import java.util.Iterator;
import net.imagej.ops.AbstractOp;
import net.imagej.ops.Op;
import net.imglib2.Cursor;
import net.imglib2.img.Img;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.ItemIO;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Op.class, name="imnorm")
public class Normalize<T extends RealType<T>>
extends AbstractOp {
    @Parameter(type=ItemIO.INPUT)
    private Img<T> inImg;
    @Parameter(type=ItemIO.INPUT)
    private double min;
    @Parameter(type=ItemIO.INPUT)
    private double max;
    @Parameter(type=ItemIO.OUTPUT)
    private Img<T> outImg;
    @Parameter
    private LogService log;

    public void run() {
        this.log.info((Object)("Normalization to [" + this.min + ", " + this.max + "]..."));
        long startTime = System.currentTimeMillis();
        this.outImg = this.inImg.factory().create(this.inImg);
        RealType gmin = (RealType)((RealType)this.inImg.firstElement()).createVariable();
        RealType gmax = (RealType)((RealType)this.inImg.firstElement()).createVariable();
        Iterator iter = this.inImg.iterator();
        RealType currentValue = (RealType)iter.next();
        gmin.set((Type)currentValue);
        gmax.set((Type)currentValue);
        while (iter.hasNext()) {
            currentValue = (RealType)iter.next();
            if (currentValue.compareTo((Object)gmin) < 0) {
                gmin.set((Type)currentValue);
                continue;
            }
            if (currentValue.compareTo((Object)gmax) <= 0) continue;
            gmax.set((Type)currentValue);
        }
        RealType gdiff = (RealType)gmax.copy();
        gdiff.sub((Object)gmin);
        Cursor cIn = this.inImg.cursor();
        Cursor cOut = this.outImg.cursor();
        while (cIn.hasNext()) {
            cIn.fwd();
            cOut.fwd();
            ((RealType)cOut.get()).set((Type)cIn.get());
            ((RealType)cOut.get()).sub((Object)gmin);
            ((RealType)cOut.get()).mul((Object)new DoubleType(this.max - this.min));
            ((RealType)cOut.get()).div((Object)gdiff);
            ((RealType)cOut.get()).add((Object)new DoubleType(this.min));
        }
        long endTime = System.currentTimeMillis();
        long fd = endTime - startTime;
        this.log.info((Object)("--- time: " + (double)fd / 1000.0 + "s."));
    }
}

