/*
 * Decompiled with CFR 0.152.
 */
package graphs;

import com.mxgraph.io.mxCodec;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxICell;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxGraphTransferable;
import com.mxgraph.swing.util.mxSwingConstants;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxGraph;
import graphs.ImageJCore;
import graphs.editor.GraphEditor;
import graphs.editor.MenuBar;
import graphs.editor.Palette;
import graphs.model.BinarizeOp;
import graphs.model.DoGaussOp;
import graphs.model.HybridOp;
import graphs.model.InputOp;
import graphs.model.Join;
import graphs.model.MathOp;
import graphs.model.NormalizeOp;
import graphs.model.Operation;
import graphs.model.OutputOp;
import graphs.model.SmoothOp;
import graphs.model.TopHatOp;
import java.awt.Color;
import java.awt.Point;
import java.text.NumberFormat;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class AlgorithmFlowEditor
extends GraphEditor {
    public static ImageJCore core;
    public static boolean isRunning;
    public static boolean isCanceled;
    public static final NumberFormat numberFormat;
    private static final long serialVersionUID = -4601740824088314699L;

    public AlgorithmFlowEditor() {
        this("Algorithm Builder", new CustomGraphComponent(new CustomGraph()));
    }

    public AlgorithmFlowEditor(ImageJCore core) {
        this();
        AlgorithmFlowEditor.core = core;
    }

    public AlgorithmFlowEditor(String appTitle, mxGraphComponent component) {
        super(appTitle, component);
        mxGraph graph = this.graphComponent.getGraph();
        Palette nodesPalette = this.insertPalette("Nodes");
        nodesPalette.addListener("select", (sender, evt) -> {
            Object tmp = evt.getProperty("transferable");
            if (tmp instanceof mxGraphTransferable) {
                mxGraphTransferable t = (mxGraphTransferable)tmp;
                Object cell = t.getCells()[0];
                if (graph.getModel().isEdge(cell)) {
                    ((CustomGraph)graph).setEdgeTemplate(cell);
                }
            }
        });
        nodesPalette.addOperation(new InputOp(), new ImageIcon(GraphEditor.class.getResource("/graphs/img/ellipse.png")), "ellipse", 100, 100);
        nodesPalette.addOperation(new OutputOp(), new ImageIcon(GraphEditor.class.getResource("/graphs/img/ellipse.png")), "ellipse", 100, 100);
        nodesPalette.addOperation(new Join(), new ImageIcon(GraphEditor.class.getResource("/graphs/img/rhombus.png")), "rhombus", 100, 100);
        nodesPalette.addOperation(new NormalizeOp(), new ImageIcon(GraphEditor.class.getResource("/graphs/img/rectangle.png")), "rectangle", 100, 100);
        nodesPalette.addOperation(new MathOp(), new ImageIcon(GraphEditor.class.getResource("/graphs/img/rectangle.png")), "rectangle", 100, 100);
        nodesPalette.addOperation(new DoGaussOp(), new ImageIcon(GraphEditor.class.getResource("/graphs/img/rectangle.png")), "rectangle", 100, 100);
        nodesPalette.addOperation(new TopHatOp(), new ImageIcon(GraphEditor.class.getResource("/graphs/img/rectangle.png")), "rectangle", 100, 100);
        nodesPalette.addOperation(new HybridOp(), new ImageIcon(GraphEditor.class.getResource("/graphs/img/rectangle.png")), "rectangle", 100, 100);
        nodesPalette.addOperation(new SmoothOp(), new ImageIcon(GraphEditor.class.getResource("/graphs/img/rectangle.png")), "rectangle", 100, 100);
        nodesPalette.addOperation(new BinarizeOp(), new ImageIcon(GraphEditor.class.getResource("/graphs/img/rectangle.png")), "rectangle", 100, 100);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        mxSwingConstants.SHADOW_COLOR = Color.LIGHT_GRAY;
        mxConstants.W3C_SHADOWCOLOR = "#D3D3D3";
        AlgorithmFlowEditor editor = new AlgorithmFlowEditor();
        editor.createFrame(new MenuBar(editor)).setVisible(true);
    }

    static {
        isRunning = false;
        isCanceled = false;
        numberFormat = NumberFormat.getInstance();
    }

    public static class CustomGraph
    extends mxGraph {
        protected Object edgeTemplate;

        public void setEdgeTemplate(Object template) {
            this.edgeTemplate = template;
        }

        public String getToolTipForCell(Object cell) {
            if (this.getModel().isEdge(cell)) {
                return null;
            }
            StringBuilder toolTip = new StringBuilder("<html>");
            Operation operation = (Operation)((mxCell)cell).getValue();
            Map<String, String> pairs = operation.getKeyValuePairs();
            pairs.forEach((k, v) -> toolTip.append((String)k).append(" = ").append((String)v).append("<br>"));
            toolTip.append("</html>");
            return toolTip.toString();
        }

        public Object createEdge(Object parent, String id, Object value, Object source, Object target, String style) {
            if (this.edgeTemplate != null) {
                mxCell edge = (mxCell)this.cloneCells(new Object[]{this.edgeTemplate})[0];
                edge.setId(id);
                return edge;
            }
            return super.createEdge(parent, id, value, source, target, style);
        }

        public boolean isAllowDanglingEdges() {
            return false;
        }

        public boolean isAllowLoops() {
            return false;
        }

        public boolean isCellResizable(Object cell) {
            return false;
        }

        public boolean isCellEditable(Object cell) {
            return false;
        }
    }

    public static class CustomGraphComponent
    extends mxGraphComponent {
        private static final long serialVersionUID = -6833603133512882012L;

        public CustomGraphComponent(mxGraph graph) {
            super(graph);
            this.setPageVisible(true);
            this.setGridVisible(true);
            this.setToolTips(true);
            this.getConnectionHandler().setCreateTarget(true);
            mxCodec codec = new mxCodec();
            Document doc = mxUtils.loadDocument((String)GraphEditor.class.getResource("/graphs/style/basic-style.xml").toString());
            codec.decode((Node)doc.getDocumentElement(), (Object)graph.getStylesheet());
            this.getViewport().setOpaque(true);
            this.getViewport().setBackground(Color.WHITE);
        }

        public Object[] importCells(Object[] cells, double dx, double dy, Object target, Point location) {
            if (target == null && cells.length == 1 && location != null && (target = this.getCellAt(location.x, location.y)) instanceof mxICell && cells[0] instanceof mxICell) {
                mxICell targetCell = (mxICell)target;
                mxICell dropCell = (mxICell)cells[0];
                if (targetCell.isVertex() == dropCell.isVertex() || targetCell.isEdge() == dropCell.isEdge()) {
                    mxIGraphModel model = this.graph.getModel();
                    model.setStyle(target, model.getStyle(cells[0]));
                    this.graph.setSelectionCell(target);
                    return null;
                }
            }
            return super.importCells(cells, dx, dy, target, location);
        }
    }
}

