/*
 * Decompiled with CFR 0.152.
 */
package graphs;

import graphs.AlgorithmGraph;
import graphs.ImageJCore;
import graphs.model.BinarizeOp;
import graphs.model.DoGaussOp;
import graphs.model.HybridOp;
import graphs.model.InputOp;
import graphs.model.MathOp;
import graphs.model.MathType;
import graphs.model.Operation;
import graphs.model.OutputOp;
import graphs.model.SmoothOp;
import graphs.model.ThresholdType;
import graphs.model.TopHatOp;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.imagej.Dataset;
import net.imagej.DefaultDataset;
import net.imagej.ImgPlus;
import net.imagej.ops.AbstractOp;
import net.imglib2.IterableInterval;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.RealType;
import ops.AverageFilter;
import ops.Binarize;
import ops.GaussianDifference;
import ops.HybridFilter;
import ops.MathFilter;
import ops.Normalize;
import ops.TophatImage;
import org.jgrapht.GraphPath;
import org.jgrapht.graph.DefaultEdge;

public class GraphProcessor {
    private ImageJCore core;
    private AlgorithmGraph algoGraph;
    private File inputDir;
    private File outputDir;
    private String datasetName;
    private List<GraphPath<Operation, DefaultEdge>> paths;
    private List<Payload> pipeline;
    private HashMap<File, Integer> outCount;

    public GraphProcessor(ImageJCore core, AlgorithmGraph algoGraph) {
        this.core = core;
        this.algoGraph = algoGraph;
        this.outCount = new HashMap();
        this.paths = algoGraph.getAllPipelines();
        this.processAllPaths();
    }

    private void processAllPaths() {
        for (GraphPath<Operation, DefaultEdge> path : this.paths) {
            this.core.getLog().info((Object)">>>>>>>>>>>>>> PROCESSING NEW PATH <<<<<<<<<<<<<<<");
            this.parsePath(path);
            this.processCurrentDataset();
            this.core.getLog().info((Object)">>>>>>>>>>>>>>>> PATH PROCESSED <<<<<<<<<<<<<<<<<<");
            this.core.getLog().info((Object)"--------------------------------------------------");
        }
        this.core.getLog().info((Object)"=============== PROCESSING FINISHED. =================");
    }

    private void parsePath(GraphPath<Operation, DefaultEdge> path) {
        List operationSequence = path.getVertexList();
        this.pipeline = new ArrayList<Payload>();
        for (Operation operation : operationSequence) {
            switch (operation.getType()) {
                case INPUT: {
                    this.datasetName = ((InputOp)operation).getDatasetName();
                    this.inputDir = ((InputOp)operation).getInputDirectory();
                    this.core.getLog().info((Object)("Added input dataset <" + this.datasetName + "> at " + this.inputDir));
                    break;
                }
                case OUTPUT: {
                    this.outputDir = ((OutputOp)operation).getOutputDirectory();
                    if (!this.outCount.containsKey(this.outputDir)) {
                        this.outCount.put(this.outputDir, 0);
                    }
                    this.outCount.put(this.outputDir, this.outCount.get(this.outputDir) + 1);
                    this.core.getLog().info((Object)("Will be saved to " + this.outputDir + " as <" + this.datasetName + "-" + this.outCount.get(this.outputDir) + ">"));
                    break;
                }
                case NORMALIZE: {
                    Payload p = new Payload(Normalize.class, Arrays.asList(0.0, 1.0));
                    this.pipeline.add(p);
                    this.core.getLog().info((Object)"- Normalize image");
                    break;
                }
                case MATH: {
                    MathOp mOp = (MathOp)operation;
                    Payload p = new Payload(MathFilter.class, Arrays.asList(new Object[]{mOp.getMathType(), mOp.getArg()}));
                    this.pipeline.add(p);
                    this.core.getLog().info((Object)(" - MathFilter: " + mOp.getMathType().toString() + ", arg = " + mOp.getArg()));
                    break;
                }
                case DOG: {
                    DoGaussOp dogOp = (DoGaussOp)operation;
                    Payload p = new Payload(GaussianDifference.class, Arrays.asList(dogOp.getSigma1(), dogOp.getSigma2()));
                    this.pipeline.add(p);
                    this.core.getLog().info((Object)("- Difference of Gaussians: sigma1 = " + dogOp.getSigma1() + ", sigma2 = " + dogOp.getSigma2()));
                    break;
                }
                case HYBRID: {
                    HybridOp hOp = (HybridOp)operation;
                    Payload p = new Payload(HybridFilter.class, Collections.singletonList(hOp.getKernelSize()));
                    this.pipeline.add(p);
                    this.core.getLog().info((Object)("- Hybrid Filter: kernelSize = " + hOp.getKernelSize()));
                    break;
                }
                case TOPHAT: {
                    TopHatOp thOp = (TopHatOp)operation;
                    Payload p = new Payload(TophatImage.class, Arrays.asList(new Object[]{thOp.getThType(), thOp.getShape(), thOp.getRadius()}));
                    this.pipeline.add(p);
                    this.core.getLog().info((Object)String.format("- %s TopHat with %s structuring element of radius %s", new Object[]{thOp.getThType().toString(), thOp.getShape(), thOp.getRadius()}));
                    break;
                }
                case MEAN: {
                    Payload p = new Payload(AverageFilter.class, Collections.singletonList(((SmoothOp)operation).getKernelSize()));
                    this.pipeline.add(p);
                    this.core.getLog().info((Object)("- Mean Smoothing: kernelSize = " + ((SmoothOp)operation).getKernelSize()));
                    break;
                }
                case BINARIZE: {
                    BinarizeOp bOp = (BinarizeOp)operation;
                    Payload p = new Payload(Binarize.class, Arrays.asList(new Object[]{bOp.getThreshType(), bOp.getDenominator(), bOp.getDoParticleAnalysis()}));
                    this.pipeline.add(p);
                    this.core.getLog().info((Object)String.format("- Binarization with threshold %s/%.4f", new Object[]{bOp.getThreshType(), bOp.getDenominator()}));
                }
            }
        }
    }

    private void processCurrentDataset() {
        this.core.getLog().info((Object)("Processing <" + this.datasetName + ">..."));
        File saveDir = new File(this.outputDir.getAbsolutePath() + File.separator + this.datasetName + "-" + this.outCount.get(this.outputDir));
        if (!saveDir.mkdir()) {
            this.core.getLog().info((Object)("Could not create " + saveDir.getAbsolutePath()));
            if (saveDir.exists()) {
                this.core.getLog().info((Object)" --- this directory exists");
            } else {
                this.core.getLog().error((Object)"!- something went wrong, moving on to the next dataset...");
                return;
            }
        }
        File[] inputImages = this.inputDir.listFiles(pathname -> !pathname.getAbsolutePath().contains(".DS_Store") && this.core.getDatasetIOService().canOpen(pathname.getAbsolutePath()));
        assert (inputImages != null);
        if (inputImages.length == 0) {
            this.core.getLog().error((Object)"!- this dataset is empty...");
            assert (saveDir.delete());
            return;
        }
        int currentImageNumber = 0;
        for (File image : inputImages) {
            Dataset currentImage;
            this.core.getStatusService().showProgress(currentImageNumber, inputImages.length);
            long startTime = System.currentTimeMillis();
            this.core.getLog().info((Object)("-- processing " + image.getName()));
            String imgPath = image.getAbsolutePath();
            try {
                currentImage = this.core.getDatasetIOService().open(imgPath);
            }
            catch (IOException e) {
                this.core.getLog().error((Object)("!- invalid image: " + image.getName()));
                continue;
            }
            Dataset result = this.process(currentImage);
            try {
                this.core.getDatasetIOService().save(result, saveDir.getAbsolutePath() + File.separator + image.getName());
            }
            catch (IOException e) {
                this.core.getLog().error((Throwable)e);
                continue;
            }
            long endTime = System.currentTimeMillis();
            long fd = endTime - startTime;
            this.core.getLog().info((Object)("-- " + image.getName() + " saved. It took " + (double)fd / 1000.0 + "s."));
            ++currentImageNumber;
        }
    }

    private Dataset process(Dataset image) {
        Img result = this.process(image.getImgPlus().getImg());
        return new DefaultDataset(image.context(), new ImgPlus(result));
    }

    private <T extends RealType<T>> Img<T> process(Img<T> image) {
        int numOperations = this.pipeline.size();
        int currentOperation = 0;
        Img img = this.core.getOps().convert().float64(image);
        for (Payload p : this.pipeline) {
            Class<? extends AbstractOp> opClass = p.getOpClass();
            List<Object> args = p.getArgs();
            this.core.getLog().info((Object)("ClassName=" + opClass.getSimpleName()));
            switch (opClass.getSimpleName()) {
                case "Normalize": {
                    this.core.getStatusService().showStatus(currentOperation, numOperations, "normalizing image...");
                    double from = (Double)args.get(0);
                    double to = (Double)args.get(1);
                    img = (Img)this.core.getOps().run(opClass, new Object[]{img, from, to});
                    break;
                }
                case "MathFilter": {
                    this.core.getStatusService().showStatus(currentOperation, numOperations, "applying MathFilter...");
                    MathType mathType = (MathType)((Object)args.get(0));
                    Double n = (Double)args.get(1);
                    img = (Img)this.core.getOps().run(opClass, new Object[]{img, mathType, n});
                    break;
                }
                case "GaussianDifference": {
                    this.core.getStatusService().showStatus(currentOperation, numOperations, "applying Difference of Gaussians...");
                    Double sigma1 = (Double)args.get(0);
                    Double sigma2 = (Double)args.get(1);
                    img = (Img)this.core.getOps().run(opClass, new Object[]{img, sigma1, sigma2});
                    break;
                }
                case "HybridFilter": {
                    this.core.getStatusService().showStatus(currentOperation, numOperations, "applying Hybrid Filter...");
                    Integer kernelSize = (Integer)args.get(0);
                    img = (Img)this.core.getOps().run(opClass, new Object[]{img, kernelSize});
                    break;
                }
                case "TophatImage": {
                    this.core.getStatusService().showStatus(currentOperation, numOperations, "applying Top-Hat...");
                    TopHatOp.ThType thType = (TopHatOp.ThType)((Object)args.get(0));
                    TopHatOp.Shape shape = (TopHatOp.Shape)((Object)args.get(1));
                    Integer radius = (Integer)args.get(2);
                    img = (Img)this.core.getOps().run(opClass, new Object[]{img, thType, shape, radius});
                    break;
                }
                case "AverageFilter": {
                    this.core.getStatusService().showStatus(currentOperation, numOperations, "applying Mean Smoothing...");
                    Integer kernelSize = (Integer)args.get(0);
                    img = (Img)this.core.getOps().run(opClass, new Object[]{img, kernelSize});
                    break;
                }
                case "Binarize": {
                    this.core.getStatusService().showStatus(currentOperation, numOperations, "applying Binarization...");
                    ThresholdType threshType = (ThresholdType)((Object)args.get(0));
                    Double denominator = (Double)args.get(1);
                    Boolean doParticleAnalysis = (Boolean)args.get(2);
                    Img binImg = (Img)this.core.getOps().run(opClass, new Object[]{img, threshType, denominator, doParticleAnalysis});
                    img = this.core.getOps().convert().float64((IterableInterval)binImg);
                    break;
                }
                case "LocalEntropyFilter": {
                    this.core.getStatusService().showStatus(currentOperation, numOperations, "applying Shannon Entropy...");
                    break;
                }
                case "MedianFilter": {
                    this.core.getStatusService().showStatus(currentOperation, numOperations, "applying Median Filter...");
                }
            }
        }
        img = (Img)this.core.getOps().run(Normalize.class, new Object[]{img, 0, 255});
        return this.core.getOps().convert().uint8((IterableInterval)img);
    }

    private class Payload {
        private Class<? extends AbstractOp> opClass;
        private List<Object> args;

        Payload(Class<? extends AbstractOp> opClass, List<Object> args) {
            this.opClass = opClass;
            this.args = args;
        }

        Class<? extends AbstractOp> getOpClass() {
            return this.opClass;
        }

        public void setOpClass(Class<? extends AbstractOp> opClass) {
            this.opClass = opClass;
        }

        List<Object> getArgs() {
            return this.args;
        }

        public void setArgs(List<Object> args) {
            this.args = args;
        }
    }
}

