/*
 * Decompiled with CFR 0.152.
 */
package graphs.editor.dialog;

import com.mxgraph.model.mxCell;
import com.mxgraph.view.mxGraph;
import graphs.editor.dialog.PropertiesDialog;
import graphs.model.MathOp;
import graphs.model.MathType;
import java.text.NumberFormat;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class MathDialog
extends PropertiesDialog {
    private MathOp mathOp;
    private MathType mathType;
    private Double arg;
    private JLabel typeLabel;
    private JRadioButton typeSqrButton;
    private JRadioButton typeSqrtButton;
    private JRadioButton typePowButton;
    private ButtonGroup typeButtonGroup;
    private JLabel argLabel;
    private JFormattedTextField argField;

    public MathDialog(mxCell cell, mxGraph graph) {
        super(cell, graph);
        this.mathOp = (MathOp)this.operation;
        this.mathType = this.mathOp.getMathType();
        this.arg = this.mathOp.getArg();
        this.populateFields();
        this.assembleDialog();
    }

    @Override
    protected void populateFields() {
        this.typeLabel = new JLabel("Operation:");
        JPanel buttonPanel = new JPanel();
        BoxLayout buttonPanelLayout = new BoxLayout(buttonPanel, 0);
        buttonPanel.setLayout(buttonPanelLayout);
        this.typeSqrButton = new JRadioButton("sqr(x)");
        this.typeSqrtButton = new JRadioButton("sqrt(x)");
        this.typePowButton = new JRadioButton("pow(x,n)");
        buttonPanel.add(this.typeSqrButton);
        buttonPanel.add(this.typeSqrtButton);
        buttonPanel.add(this.typePowButton);
        this.typeButtonGroup = new ButtonGroup();
        this.typeButtonGroup.add(this.typeSqrButton);
        this.typeButtonGroup.add(this.typeSqrtButton);
        this.typeButtonGroup.add(this.typePowButton);
        NumberFormat doubleFormat = NumberFormat.getNumberInstance();
        doubleFormat.setMinimumFractionDigits(2);
        this.argLabel = new JLabel("Power:");
        this.argField = new JFormattedTextField(doubleFormat);
        this.argField.setValue(this.arg);
        this.typeSqrButton.addActionListener(e -> {
            this.mathType = MathType.SQUARE;
            this.argLabel.setVisible(false);
            this.argField.setVisible(false);
        });
        this.typeSqrtButton.addActionListener(e -> {
            this.mathType = MathType.SQRT;
            this.argLabel.setVisible(false);
            this.argField.setVisible(false);
        });
        this.typePowButton.addActionListener(e -> {
            this.mathType = MathType.POW;
            this.argLabel.setVisible(true);
            this.argField.setVisible(true);
        });
        switch (this.mathType) {
            case SQUARE: {
                this.typeSqrButton.setSelected(true);
                this.argLabel.setVisible(false);
                this.argField.setVisible(false);
                break;
            }
            case SQRT: {
                this.typeSqrtButton.setSelected(true);
                this.argLabel.setVisible(false);
                this.argField.setVisible(false);
                break;
            }
            case POW: {
                this.typePowButton.setSelected(true);
                this.argLabel.setVisible(true);
                this.argField.setVisible(true);
            }
        }
        this.labelPanel.add(this.typeLabel);
        this.fieldPanel.add(buttonPanel);
        this.labelPanel.add(this.argLabel);
        this.fieldPanel.add(this.argField);
    }

    @Override
    protected void save() {
        this.mathOp.setMathType(this.mathType);
        if (this.argField.isVisible()) {
            this.mathOp.setArg(((Number)this.argField.getValue()).doubleValue());
        }
        this.graph.refresh();
    }
}

