/*
 * Decompiled with CFR 0.152.
 */
package graphs.model;

import graphs.model.MathType;
import graphs.model.OpType;
import graphs.model.Operation;
import java.util.Map;

public class MathOp
extends Operation {
    private MathType mathType;
    private Double arg;

    public MathOp() {
        super("Math", OpType.MATH);
        this.mathType = MathType.SQUARE;
        this.arg = Double.NaN;
    }

    public MathOp(MathType mathType) {
        super("Math", OpType.MATH);
        this.mathType = mathType;
    }

    public void clearArg() {
        this.arg = Double.NaN;
    }

    public MathType getMathType() {
        return this.mathType;
    }

    public void setMathType(MathType mathType) {
        this.mathType = mathType;
    }

    public Double getArg() {
        return this.arg;
    }

    public void setArg(Double arg) {
        this.arg = arg;
    }

    @Override
    public boolean isValid() {
        if (this.mathType == MathType.SQUARE || this.mathType == MathType.SQRT) {
            return true;
        }
        if (this.mathType == MathType.POW) {
            return this.arg != Double.NaN;
        }
        return true;
    }

    @Override
    public Map<String, String> getKeyValuePairs() {
        Map<String, String> map = super.getKeyValuePairs();
        map.put("mathType", String.valueOf((Object)this.mathType));
        map.put("arg", String.valueOf(this.arg));
        return map;
    }

    @Override
    public String toString() {
        switch (this.mathType) {
            case SQUARE: {
                return String.format("%s\nsqr(x)", super.toString());
            }
            case SQRT: {
                return String.format("%s\nsqrt(x)", super.toString());
            }
            case POW: {
                return String.format("%s\npow(x, %s)", super.toString(), this.arg);
            }
        }
        return "ERROR";
    }
}

