/*
 * Decompiled with CFR 0.152.
 */
package ops;

import net.imagej.ops.AbstractOp;
import net.imagej.ops.Op;
import net.imagej.ops.OpService;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.gauss3.Gauss3;
import net.imglib2.img.Img;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.Views;
import org.scijava.ItemIO;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Op.class, name="gaussdiff")
public class GaussianDifference<T extends RealType<T>>
extends AbstractOp {
    @Parameter(type=ItemIO.INPUT)
    private Img<T> inImg;
    @Parameter(type=ItemIO.INPUT)
    private double sigma1;
    @Parameter(type=ItemIO.INPUT)
    private double sigma2;
    @Parameter(type=ItemIO.OUTPUT)
    private Img<T> outImg;
    @Parameter
    private OpService ops;
    @Parameter
    private LogService log;

    public void run() {
        this.log.info((Object)("DoG, sigma1 = " + this.sigma1 + ", sigma2 = " + this.sigma2 + "..."));
        long startTime = System.currentTimeMillis();
        double[] sigmas1 = new double[]{this.sigma1, this.sigma1};
        double[] sigmas2 = new double[]{this.sigma2, this.sigma2};
        Img in1 = this.inImg.copy();
        ExtendedRandomAccessibleInterval inf1 = Views.extendValue((RandomAccessibleInterval)in1, (Type)new DoubleType());
        Gauss3.gauss((double[])sigmas1, (RandomAccessible)inf1, (RandomAccessibleInterval)in1);
        Img in2 = this.inImg.copy();
        ExtendedRandomAccessibleInterval inf2 = Views.extendValue((RandomAccessibleInterval)in2, (Type)new DoubleType());
        Gauss3.gauss((double[])sigmas2, (RandomAccessible)inf2, (RandomAccessibleInterval)in2);
        this.outImg = (Img)this.ops.math().subtract((IterableInterval)in1, (RandomAccessibleInterval)in2);
        long endTime = System.currentTimeMillis();
        long fd = endTime - startTime;
        this.log.info((Object)("--- time: " + (double)fd / 1000.0 + "s."));
    }
}

