/*
 * Decompiled with CFR 0.152.
 */
package graphs;

import com.mxgraph.model.mxCell;
import com.mxgraph.view.mxGraph;
import graphs.model.OpType;
import graphs.model.Operation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.shortestpath.AllDirectedPaths;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;

public class AlgorithmGraph
extends DefaultDirectedGraph<Operation, DefaultEdge> {
    private mxGraph oldGraph;
    private Set<Operation> sources;
    private Set<Operation> targets;

    public AlgorithmGraph(mxGraph oldGraph) {
        super(DefaultEdge.class);
        this.oldGraph = oldGraph;
        this.sources = new HashSet<Operation>();
        this.targets = new HashSet<Operation>();
        this.convertGraph();
    }

    private void convertGraph() {
        this.oldGraph.selectCells(false, true);
        mxCell[] edges = (mxCell[])Arrays.stream(this.oldGraph.getSelectionCells()).toArray(mxCell[]::new);
        this.oldGraph.selectCells(false, false);
        assert (Arrays.stream(edges).allMatch(mxCell::isEdge));
        for (mxCell edge : edges) {
            mxCell src = (mxCell)edge.getSource();
            mxCell trg = (mxCell)edge.getTarget();
            Operation srcOp = null;
            Operation trgOp = null;
            if (src != null) {
                srcOp = (Operation)src.getValue();
                if (srcOp.getType() == OpType.INPUT) {
                    this.sources.add(srcOp);
                }
                this.addVertex(srcOp);
            }
            if (trg != null) {
                trgOp = (Operation)trg.getValue();
                if (trgOp.getType() == OpType.OUTPUT) {
                    this.targets.add(trgOp);
                }
                this.addVertex(trgOp);
            }
            if (src == null || trg == null) continue;
            this.addEdge(srcOp, trgOp);
        }
    }

    public List<GraphPath<Operation, DefaultEdge>> getAllPipelines() {
        AllDirectedPaths adp = new AllDirectedPaths((Graph)this);
        return adp.getAllPaths(this.sources, this.targets, true, null);
    }
}

