/*
 * Decompiled with CFR 0.152.
 */
package graphs.editor;

import com.mxgraph.io.mxCodecRegistry;
import com.mxgraph.io.mxObjectCodec;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.swing.util.mxGraphTransferable;
import com.mxgraph.swing.util.mxSwingConstants;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxRectangle;
import graphs.editor.ShadowBorder;
import graphs.model.Operation;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.TransferHandler;

public class Palette
extends JPanel {
    private static final long serialVersionUID = 7771113885935187066L;
    protected JLabel selectedEntry = null;
    protected mxEventSource eventSource = new mxEventSource((Object)this);
    protected Color gradientColor = Color.WHITE;

    public Palette() {
        this.setBackground(Color.WHITE);
        this.setLayout(new FlowLayout(3, 5, 5));
        this.addMouseListener(new MouseListener(){

            @Override
            public void mousePressed(MouseEvent e) {
                Palette.this.clearSelection();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.setTransferHandler(new TransferHandler(){

            @Override
            public boolean canImport(JComponent comp, DataFlavor[] flavors) {
                return true;
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.gradientColor == null) {
            super.paintComponent(g);
        } else {
            Rectangle rect = this.getVisibleRect();
            if (g.getClipBounds() != null) {
                rect = rect.intersection(g.getClipBounds());
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(new GradientPaint(0.0f, 0.0f, this.getBackground(), this.getWidth(), 0.0f, this.gradientColor));
            g2.fill(rect);
        }
    }

    public void clearSelection() {
        this.setSelectionEntry(null, null);
    }

    public void setSelectionEntry(JLabel entry, mxGraphTransferable t) {
        JLabel previous = this.selectedEntry;
        this.selectedEntry = entry;
        if (previous != null) {
            previous.setBorder(null);
            previous.setOpaque(false);
        }
        if (this.selectedEntry != null) {
            this.selectedEntry.setBorder(ShadowBorder.getSharedInstance());
            this.selectedEntry.setOpaque(true);
        }
        this.eventSource.fireEvent(new mxEventObject("select", new Object[]{"entry", this.selectedEntry, "transferable", t, "previous", previous}));
    }

    public void setPreferredWidth(int width) {
        int cols = Math.max(1, width / 55);
        this.setPreferredSize(new Dimension(width, this.getComponentCount() * 55 / cols + 30));
        this.revalidate();
    }

    public void addOperation(Operation opObject, ImageIcon icon, String style, int width, int height) {
        mxCodecRegistry.addPackage((String)opObject.getClass().getPackage().toString());
        try {
            mxCodecRegistry.register((mxObjectCodec)new mxObjectCodec(opObject.getClass().newInstance()));
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        mxCell cell = new mxCell((Object)opObject, new mxGeometry(0.0, 0.0, (double)width, (double)height), style);
        cell.setVertex(true);
        this.addTemplate(opObject.getName(), icon, cell);
    }

    public void addTemplate(String name, ImageIcon icon, mxCell cell) {
        mxGeometry bounds = (mxGeometry)cell.getGeometry().clone();
        final mxGraphTransferable t = new mxGraphTransferable(new Object[]{cell}, (mxRectangle)bounds);
        if (icon != null && (icon.getIconWidth() > 32 || icon.getIconHeight() > 32)) {
            icon = new ImageIcon(icon.getImage().getScaledInstance(32, 32, 0));
        }
        final JLabel entry = new JLabel(icon);
        entry.setPreferredSize(new Dimension(50, 50));
        entry.setBackground(this.getBackground().brighter());
        entry.setFont(new Font(entry.getFont().getFamily(), 0, 10));
        entry.setVerticalTextPosition(3);
        entry.setHorizontalTextPosition(0);
        entry.setIconTextGap(0);
        entry.setToolTipText(name);
        entry.setText(name);
        entry.addMouseListener(new MouseListener(){

            @Override
            public void mousePressed(MouseEvent e) {
                Palette.this.setSelectionEntry(entry, t);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        DragGestureListener dragGestureListener = e -> e.startDrag(null, mxSwingConstants.EMPTY_IMAGE, new Point(), (Transferable)t, null);
        DragSource dragSource = new DragSource();
        dragSource.createDefaultDragGestureRecognizer(entry, 1, dragGestureListener);
        this.add(entry);
    }

    public void addListener(String eventName, mxEventSource.mxIEventListener listener) {
        this.eventSource.addListener(eventName, listener);
    }

    public boolean isEventsEnabled() {
        return this.eventSource.isEventsEnabled();
    }

    public void setEventsEnabled(boolean eventsEnabled) {
        this.eventSource.setEventsEnabled(eventsEnabled);
    }

    public void removeListener(mxEventSource.mxIEventListener listener) {
        this.eventSource.removeListener(listener);
    }

    public void removeListener(mxEventSource.mxIEventListener listener, String eventName) {
        this.eventSource.removeListener(listener, eventName);
    }
}

