/*
 * Decompiled with CFR 0.152.
 */
package graphs.editor.dialog;

import com.mxgraph.model.mxCell;
import com.mxgraph.view.mxGraph;
import graphs.editor.dialog.PropertiesDialog;
import graphs.model.BinarizeOp;
import graphs.model.ThresholdType;
import java.text.NumberFormat;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;

public class BinarizeDialog
extends PropertiesDialog {
    private BinarizeOp binOp;
    private ThresholdType threshType;
    private Double denominator;
    private Boolean doParticleAnalysis;
    private JLabel typeLabel;
    private JComboBox<ThresholdType> typeBox;
    private ThresholdType[] types = new ThresholdType[]{ThresholdType.MEAN, ThresholdType.MEDIAN, ThresholdType.OTSU, ThresholdType.MAX_ENTROPY, ThresholdType.ISO_DATA, ThresholdType.RENYI, ThresholdType.HUANG};
    private JLabel denominatorLabel;
    private JFormattedTextField denominatorField;
    private JLabel convertLabel;
    private JCheckBox convertCheckBox;
    private JLabel analysisLabel;
    private JCheckBox analysisCheckBox;

    public BinarizeDialog(mxCell cell, mxGraph graph) {
        super(cell, graph);
        this.binOp = (BinarizeOp)this.operation;
        this.threshType = this.binOp.getThreshType();
        this.denominator = this.binOp.getDenominator();
        this.doParticleAnalysis = this.binOp.getDoParticleAnalysis();
        this.populateFields();
        this.assembleDialog();
    }

    @Override
    protected void populateFields() {
        this.typeLabel = new JLabel("Threshold type:");
        this.typeBox = new JComboBox<ThresholdType>(this.types);
        this.typeBox.setSelectedItem((Object)this.threshType);
        this.typeBox.addActionListener(e -> {
            this.threshType = (ThresholdType)((Object)((Object)((JComboBox)e.getSource()).getSelectedItem()));
        });
        NumberFormat doubleFormat = NumberFormat.getNumberInstance();
        doubleFormat.setMinimumFractionDigits(0);
        doubleFormat.setMaximumFractionDigits(10);
        this.denominatorLabel = new JLabel("Denominator:");
        this.denominatorField = new JFormattedTextField(doubleFormat);
        this.denominatorField.setValue(this.denominator);
        this.convertLabel = new JLabel();
        this.convertCheckBox = new JCheckBox("3.14...->PI & 2.71...->E");
        this.analysisLabel = new JLabel("Try particle analysis for cleaning up the mask (may cause errors!)");
        this.analysisCheckBox = new JCheckBox("Particle Analysis");
        this.analysisCheckBox.setSelected(this.doParticleAnalysis);
        this.labelPanel.add(this.typeLabel);
        this.fieldPanel.add(this.typeBox);
        this.labelPanel.add(this.denominatorLabel);
        this.fieldPanel.add(this.denominatorField);
        this.labelPanel.add(this.convertLabel);
        this.fieldPanel.add(this.convertCheckBox);
        this.labelPanel.add(this.analysisLabel);
        this.fieldPanel.add(this.analysisCheckBox);
    }

    @Override
    protected void save() {
        this.binOp.setThreshType(this.threshType);
        Double denom = ((Number)this.denominatorField.getValue()).doubleValue();
        if (Math.abs(denom - Math.PI) < 0.01 && this.convertCheckBox.isSelected()) {
            denom = Math.PI;
        } else if (Math.abs(denom - Math.E) < 0.01 && this.convertCheckBox.isSelected()) {
            denom = Math.E;
        }
        this.binOp.setDenominator(denom);
        this.binOp.setDoParticleAnalysis(this.analysisCheckBox.isSelected());
        this.graph.refresh();
    }
}

