/*
 * Decompiled with CFR 0.152.
 */
package graphs.editor.dialog;

import com.mxgraph.model.mxCell;
import com.mxgraph.view.mxGraph;
import graphs.editor.dialog.PropertiesDialog;
import graphs.model.InputOp;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileSystemView;

public class InputDialog
extends PropertiesDialog {
    private InputOp inputOp;
    private String datasetName;
    private File inputDirectory;
    private JLabel datasetNameLabel;
    private JTextField datasetNameField;
    private JLabel inputDirectoryLabel;
    private JButton inputDirectoryButton;
    private JFileChooser inputDirectoryChooser;

    public InputDialog(mxCell cell, mxGraph graph) {
        super(cell, graph);
        this.inputOp = (InputOp)this.operation;
        this.datasetName = this.inputOp.getDatasetName();
        this.inputDirectory = this.inputOp.getInputDirectory();
        this.populateFields();
        this.assembleDialog();
    }

    @Override
    protected void populateFields() {
        this.datasetNameLabel = new JLabel("Dataset name:");
        this.datasetNameField = new JTextField(this.datasetName);
        this.inputDirectoryLabel = new JLabel("Dataset directory:");
        this.inputDirectoryButton = new JButton("Browse...");
        this.inputDirectoryChooser = new JFileChooser(FileSystemView.getFileSystemView().getHomeDirectory());
        this.inputDirectoryChooser.setSelectedFile(this.inputDirectory);
        this.inputDirectoryChooser.setFileSelectionMode(1);
        this.inputDirectoryButton.addActionListener(e -> {
            int returnValue = this.inputDirectoryChooser.showOpenDialog(null);
            if (returnValue == 0) {
                this.inputDirectory = this.inputDirectoryChooser.getSelectedFile();
            }
        });
        this.labelPanel.add(this.datasetNameLabel);
        this.fieldPanel.add(this.datasetNameField);
        this.labelPanel.add(this.inputDirectoryLabel);
        this.fieldPanel.add(this.inputDirectoryButton);
    }

    @Override
    protected void save() {
        this.inputOp.setDatasetName(this.datasetNameField.getText());
        this.inputOp.setInputDirectory(this.inputDirectory);
        this.graph.refresh();
    }
}

