/*
 * Decompiled with CFR 0.152.
 */
package graphs.editor.dialog;

import com.mxgraph.model.mxCell;
import com.mxgraph.view.mxGraph;
import graphs.editor.dialog.PropertiesDialog;
import graphs.model.TopHatOp;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;

public class TopHatDialog
extends PropertiesDialog {
    private TopHatOp topHatOp;
    private TopHatOp.ThType thType;
    private TopHatOp.Shape shape;
    private int radius;
    private JLabel typeLabel;
    private JRadioButton typeWhiteButton;
    private JRadioButton typeBlackButton;
    private ButtonGroup typeButtonGroup;
    private JLabel shapeLabel;
    private JComboBox<TopHatOp.Shape> shapeBox;
    private JLabel radiusLabel;
    private JSlider radiusSlider;
    private TopHatOp.Shape[] shapeStrings = new TopHatOp.Shape[]{TopHatOp.Shape.DISK, TopHatOp.Shape.DIAMOND, TopHatOp.Shape.SQUARE};

    public TopHatDialog(mxCell cell, mxGraph graph) {
        super(cell, graph);
        this.topHatOp = (TopHatOp)this.operation;
        this.thType = this.topHatOp.getThType();
        this.shape = this.topHatOp.getShape();
        this.radius = this.topHatOp.getRadius();
        this.populateFields();
        this.assembleDialog();
    }

    @Override
    protected void populateFields() {
        this.typeLabel = new JLabel("Type:");
        JPanel buttonPanel = new JPanel();
        BoxLayout buttonPanelLayout = new BoxLayout(buttonPanel, 0);
        buttonPanel.setLayout(buttonPanelLayout);
        this.typeWhiteButton = new JRadioButton("White");
        this.typeBlackButton = new JRadioButton("Black");
        buttonPanel.add(this.typeWhiteButton);
        buttonPanel.add(this.typeBlackButton);
        this.typeButtonGroup = new ButtonGroup();
        this.typeButtonGroup.add(this.typeWhiteButton);
        this.typeButtonGroup.add(this.typeBlackButton);
        this.typeWhiteButton.setSelected(true);
        this.typeWhiteButton.addActionListener(e -> {
            this.thType = TopHatOp.ThType.WHITE;
        });
        this.typeBlackButton.addActionListener(e -> {
            this.thType = TopHatOp.ThType.BLACK;
        });
        this.shapeLabel = new JLabel("Shape:");
        this.shapeBox = new JComboBox<TopHatOp.Shape>(this.shapeStrings);
        this.shapeBox.setSelectedItem((Object)TopHatOp.Shape.DISK);
        this.shapeBox.addActionListener(e -> {
            this.shape = (TopHatOp.Shape)((Object)((Object)((JComboBox)e.getSource()).getSelectedItem()));
        });
        this.radiusLabel = new JLabel("Radius:");
        this.radiusSlider = new JSlider(0, 1, 20, 6);
        this.radiusSlider.addChangeListener(e -> {
            this.radius = ((JSlider)e.getSource()).getValue();
        });
        this.radiusSlider.setMajorTickSpacing(4);
        this.radiusSlider.setMinorTickSpacing(1);
        this.radiusSlider.setPaintTicks(true);
        this.radiusSlider.setPaintLabels(true);
        this.radiusSlider.setSnapToTicks(true);
        this.labelPanel.add(this.typeLabel);
        this.fieldPanel.add(buttonPanel);
        this.labelPanel.add(this.shapeLabel);
        this.fieldPanel.add(this.shapeBox);
        this.labelPanel.add(this.radiusLabel);
        this.fieldPanel.add(this.radiusSlider);
    }

    @Override
    protected void save() {
        this.topHatOp.setThType(this.thType);
        this.topHatOp.setShape(this.shape);
        this.topHatOp.setRadius(this.radius);
        this.graph.refresh();
    }
}

