/*
 * Decompiled with CFR 0.152.
 */
package graphs.model;

import graphs.model.OpType;
import graphs.model.Operation;
import java.io.File;
import java.util.Map;

public class InputOp
extends Operation {
    private String datasetName;
    private File inputDirectory;

    public InputOp() {
        super("Input", OpType.INPUT);
    }

    @Override
    public Map<String, String> getKeyValuePairs() {
        Map<String, String> map = super.getKeyValuePairs();
        map.put("datasetName", this.datasetName != null ? this.datasetName : "None");
        map.put("inputDirectory", this.inputDirectory != null ? this.inputDirectory.toString() : "None");
        return map;
    }

    @Override
    public String toString() {
        String str = super.toString();
        if (this.datasetName != null) {
            str = str + String.format("\ndatasetName = %s", this.datasetName);
        }
        if (this.inputDirectory != null) {
            str = str + String.format("\ninputDir = %s", this.inputDirectory.toString());
        }
        return str;
    }

    @Override
    public boolean isValid() {
        return this.datasetName != null && !this.datasetName.isEmpty() && this.inputDirectory != null && this.inputDirectory.isDirectory();
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public void setDatasetName(String datasetName) {
        this.datasetName = datasetName;
    }

    public File getInputDirectory() {
        return this.inputDirectory;
    }

    public void setInputDirectory(File inputDirectory) {
        this.inputDirectory = inputDirectory;
    }
}

