/*
 * Decompiled with CFR 0.152.
 */
package ops;

import graphs.model.ThresholdType;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.measure.ResultsTable;
import ij.plugin.filter.ParticleAnalyzer;
import ij.plugin.frame.RoiManager;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.util.List;
import net.imagej.ops.AbstractOp;
import net.imagej.ops.Op;
import net.imagej.ops.OpService;
import net.imglib2.IterableInterval;
import net.imglib2.algorithm.morphology.Closing;
import net.imglib2.algorithm.morphology.Dilation;
import net.imglib2.algorithm.morphology.Erosion;
import net.imglib2.algorithm.morphology.StructuringElements;
import net.imglib2.img.Img;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.ItemIO;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Op.class, name="binarize")
public class Binarize
extends AbstractOp {
    @Parameter(type=ItemIO.INPUT)
    private Img<DoubleType> inImg;
    @Parameter(type=ItemIO.INPUT)
    private ThresholdType threshType;
    @Parameter(type=ItemIO.INPUT)
    private Double denominator;
    @Parameter(type=ItemIO.INPUT)
    private Boolean doParticleAnalysis;
    @Parameter(type=ItemIO.OUTPUT)
    private Img<BitType> outImg;
    @Parameter
    private OpService ops;
    @Parameter
    private LogService log;

    public void run() {
        this.log.info((Object)"Binarization...");
        long startTime = System.currentTimeMillis();
        this.log.info((Object)"--- applying threshold");
        switch (this.threshType) {
            case MEAN: {
                this.outImg = (Img)this.ops.threshold().apply(this.inImg, (RealType)new DoubleType(this.ops.stats().mean(this.inImg).getRealDouble() / this.denominator));
                break;
            }
            case MEDIAN: {
                this.outImg = (Img)this.ops.threshold().apply(this.inImg, (RealType)new DoubleType(this.ops.stats().median(this.inImg).getRealDouble() / this.denominator));
                break;
            }
            case OTSU: {
                this.outImg = (Img)this.ops.threshold().otsu(this.inImg);
                break;
            }
            case HUANG: {
                this.outImg = (Img)this.ops.threshold().huang(this.inImg);
                break;
            }
            case RENYI: {
                this.outImg = (Img)this.ops.threshold().renyiEntropy(this.inImg);
                break;
            }
            case ISO_DATA: {
                this.outImg = (Img)this.ops.threshold().isoData(this.inImg);
                break;
            }
            case MAX_ENTROPY: {
                this.outImg = (Img)this.ops.threshold().maxEntropy(this.inImg);
            }
        }
        this.log.info((Object)"--- inverting image...");
        this.outImg.forEach(p -> p.set(!p.get()));
        this.log.info((Object)"--- filling holes...");
        this.outImg = (Img)this.ops.morphology().fillHoles(this.outImg);
        List strel1 = StructuringElements.disk((long)1L, (int)2);
        List strel2 = StructuringElements.disk((long)2L, (int)2);
        List strel3 = StructuringElements.disk((long)3L, (int)2);
        this.log.info((Object)"--- closing...");
        this.outImg = Closing.close(this.outImg, (List)strel1, (int)4);
        this.outImg = Dilation.dilate(this.outImg, (List)strel1, (int)4);
        this.outImg = Closing.close(this.outImg, (List)strel1, (int)4);
        this.outImg = Erosion.erode(this.outImg, (List)strel2, (int)4);
        this.log.info((Object)"--- inverting image...");
        this.outImg.forEach(p -> p.set(!p.get()));
        if (this.doParticleAnalysis.booleanValue()) {
            RoiManager roiManager = new RoiManager(true);
            ResultsTable rt = new ResultsTable();
            ParticleAnalyzer particleAnalyzer = new ParticleAnalyzer(2048, 1, rt, 0.0, Double.POSITIVE_INFINITY);
            ParticleAnalyzer.setRoiManager((RoiManager)roiManager);
            particleAnalyzer.setHideOutputImage(true);
            ImagePlus invImp = ImageJFunctions.wrapBit(this.outImg, (String)"Binarized (Dirty)");
            ByteProcessor ip = invImp.getProcessor().convertToByteProcessor();
            assert (ip.isBinary());
            ip.snapshot();
            if (particleAnalyzer.analyze(invImp, (ImageProcessor)ip)) {
                this.log.info((Object)"--- wound particle detection successful");
                Roi[] rois = roiManager.getRoisAsArray();
                assert (roiManager.getRoi(0).equals((Object)rois[0]));
                int[] maxIndices = new int[]{-1, -1};
                long currentMax1 = 0L;
                long currentMax2 = 0L;
                for (int i = 0; i < rois.length; ++i) {
                    long probe = rois[i].getStatistics().longPixelCount;
                    if (probe > currentMax1) {
                        currentMax2 = currentMax1;
                        maxIndices[1] = maxIndices[0];
                        currentMax1 = probe;
                        maxIndices[0] = i;
                        continue;
                    }
                    if (probe <= currentMax2) continue;
                    currentMax2 = probe;
                    maxIndices[1] = i;
                }
                int[] roiIndices = new int[rois.length - 2];
                int j = 0;
                for (int i = 0; i < rois.length; ++i) {
                    if (i == maxIndices[0] || i == maxIndices[1]) continue;
                    roiIndices[j] = i;
                    ++j;
                }
                for (int i : roiIndices) {
                    ip.setRoi(rois[i]);
                    ip.setValue(0.0);
                    ip.fill();
                    ip.reset(ip.getMask());
                }
                this.log.info((Object)"--- wound artifacts fixed");
            } else {
                this.log.error((Object)"--- wound particle detection failed");
            }
            ip.resetRoi();
            ip.invert();
            roiManager.reset();
            rt.reset();
            ParticleAnalyzer particleAnalyzer2 = new ParticleAnalyzer(2048, 1, rt, 1000.0, Double.POSITIVE_INFINITY);
            ParticleAnalyzer.setRoiManager((RoiManager)roiManager);
            particleAnalyzer2.setHideOutputImage(true);
            ImagePlus imp = new ImagePlus("Fixed Wound, white monolayer", (ImageProcessor)ip);
            ByteProcessor ip2 = imp.getProcessor().convertToByteProcessor();
            assert (ip2.isBinary());
            if (particleAnalyzer2.analyze(imp, (ImageProcessor)ip2)) {
                this.log.info((Object)"--- wound detection successful");
                Roi[] rois = roiManager.getRoisAsArray();
                assert (roiManager.getRoi(0).equals((Object)rois[0]));
                int maxIndex = -1;
                long currentMax = 0L;
                for (int i = 0; i < rois.length; ++i) {
                    long probe = rois[i].getStatistics().longPixelCount;
                    if (probe <= currentMax) continue;
                    currentMax = probe;
                    maxIndex = i;
                }
                Roi antiWound = roiManager.getRoi(maxIndex).getInverse(imp);
                assert (antiWound != null);
                ip2.setRoi(antiWound);
                ip2.setValue(0.0);
                ip2.fill();
                ip2.reset(ip2.getMask());
                ip2.resetRoi();
                this.log.info((Object)"--- wound extracted");
            } else {
                this.log.error((Object)"--- wound detection failed");
            }
            roiManager.reset();
            rt.reset();
            Img invImg = ImageJFunctions.wrap((ImagePlus)new ImagePlus("Binarized (Clean)", (ImageProcessor)ip2));
            this.outImg = this.ops.convert().bit((IterableInterval)invImg);
        }
        this.outImg = Closing.close(this.outImg, (List)strel3, (int)4);
        long endTime = System.currentTimeMillis();
        long fd = endTime - startTime;
        this.log.info((Object)("--- time: " + (double)fd / 1000.0 + "s."));
    }
}

