/*
 * Decompiled with CFR 0.152.
 */
package ops;

import graphs.model.MathType;
import net.imagej.ops.AbstractOp;
import net.imagej.ops.Op;
import net.imglib2.Cursor;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.ItemIO;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Op.class, name="imsquare")
public class MathFilter
extends AbstractOp {
    @Parameter(type=ItemIO.INPUT)
    private Img<DoubleType> inImg;
    @Parameter(type=ItemIO.INPUT)
    private MathType mathType;
    @Parameter(type=ItemIO.INPUT)
    private Double n;
    @Parameter(type=ItemIO.OUTPUT)
    private Img<DoubleType> outImg;
    @Parameter
    private LogService log;

    public void run() {
        this.log.info((Object)"SquareOp Image...");
        long startTime = System.currentTimeMillis();
        if (this.mathType == MathType.POW && this.n == null) {
            throw new IllegalArgumentException("MathFilter requires a power if POW is used");
        }
        this.outImg = this.inImg.factory().create(this.inImg);
        Cursor cIn = this.inImg.cursor();
        Cursor cOut = this.outImg.cursor();
        while (cIn.hasNext()) {
            cIn.fwd();
            cOut.fwd();
            switch (this.mathType) {
                case SQUARE: {
                    ((DoubleType)cOut.get()).set(Math.pow(((DoubleType)cIn.get()).get(), 2.0));
                    break;
                }
                case SQRT: {
                    ((DoubleType)cOut.get()).set(Math.sqrt(((DoubleType)cIn.get()).get()));
                    break;
                }
                case POW: {
                    ((DoubleType)cOut.get()).set(Math.pow(((DoubleType)cIn.get()).get(), this.n));
                }
            }
        }
        long endTime = System.currentTimeMillis();
        long fd = endTime - startTime;
        this.log.info((Object)("--- time: " + (double)fd / 1000.0 + "s."));
    }
}

