/*
 * Decompiled with CFR 0.152.
 */
package ops;

import graphs.model.TopHatOp;
import java.util.List;
import net.imagej.ops.AbstractOp;
import net.imagej.ops.Op;
import net.imglib2.algorithm.morphology.BlackTopHat;
import net.imglib2.algorithm.morphology.StructuringElements;
import net.imglib2.algorithm.morphology.TopHat;
import net.imglib2.algorithm.neighborhood.Shape;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.RealType;
import org.scijava.ItemIO;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Op.class, name="tophatimage")
public class TophatImage<T extends RealType<T>>
extends AbstractOp {
    @Parameter(type=ItemIO.INPUT)
    private Img<T> inImg;
    @Parameter(type=ItemIO.INPUT)
    private TopHatOp.ThType thType;
    @Parameter(type=ItemIO.INPUT)
    private TopHatOp.Shape shape;
    @Parameter(type=ItemIO.INPUT)
    private int radius;
    @Parameter(type=ItemIO.OUTPUT)
    private Img<T> outImg;
    @Parameter
    private LogService log;

    public void run() {
        this.log.info((Object)"Top Hat Transform...");
        long startTime = System.currentTimeMillis();
        List<Shape> strel = Helper.getStrel(this.shape, this.radius);
        switch (this.thType) {
            case WHITE: {
                this.outImg = TopHat.topHat(this.inImg, strel, (int)4);
                break;
            }
            case BLACK: {
                this.outImg = BlackTopHat.blackTopHat(this.inImg, strel, (int)4);
            }
        }
        long endTime = System.currentTimeMillis();
        long fd = endTime - startTime;
        this.log.info((Object)("--- time: " + (double)fd / 1000.0 + "s."));
    }

    private static class Helper {
        private static List<Shape> strel;

        private Helper() {
        }

        static List<Shape> getStrel(TopHatOp.Shape shape, int radius) {
            if (strel != null) {
                return strel;
            }
            switch (shape) {
                case SQUARE: {
                    strel = StructuringElements.square((int)radius, (int)2);
                    break;
                }
                case DISK: {
                    strel = StructuringElements.disk((long)radius, (int)2);
                    break;
                }
                case DIAMOND: {
                    strel = StructuringElements.diamond((int)radius, (int)2);
                    break;
                }
                default: {
                    strel = StructuringElements.disk((long)radius, (int)2);
                }
            }
            return strel;
        }
    }
}

