/*
 * Decompiled with CFR 0.152.
 */
package graphs.editor;

import com.mxgraph.analysis.StructuralException;
import com.mxgraph.analysis.mxAnalysisGraph;
import com.mxgraph.analysis.mxGraphProperties;
import com.mxgraph.analysis.mxGraphStructure;
import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.canvas.mxICanvas;
import com.mxgraph.canvas.mxSvgCanvas;
import com.mxgraph.io.mxCodec;
import com.mxgraph.io.mxGdCodec;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.model.mxICell;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.swing.handler.mxConnectionHandler;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxGraphActions;
import com.mxgraph.util.mxCellRenderer;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxDomUtils;
import com.mxgraph.util.mxResources;
import com.mxgraph.util.mxUtils;
import com.mxgraph.util.mxXmlUtils;
import com.mxgraph.util.png.mxPngEncodeParam;
import com.mxgraph.util.png.mxPngImageEncoder;
import com.mxgraph.util.png.mxPngTextDecoder;
import com.mxgraph.view.mxGraph;
import fiji.util.gui.GenericDialogPlus;
import graphs.AlgorithmFlowEditor;
import graphs.AlgorithmGraph;
import graphs.GraphProcessor;
import graphs.editor.DefaultFileFilter;
import graphs.editor.GraphEditor;
import graphs.editor.dialog.PropertiesDialog;
import graphs.editor.dialog.PropertiesDialogFactory;
import graphs.model.OpType;
import graphs.model.Operation;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Actions {
    public static GraphEditor getEditor(ActionEvent e) {
        if (e.getSource() instanceof Component) {
            Component component;
            for (component = (Component)e.getSource(); component != null && !(component instanceof GraphEditor); component = component.getParent()) {
            }
            return (GraphEditor)component;
        }
        return null;
    }

    public static class ValidateGraphAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (AlgorithmFlowEditor.isRunning) {
                GenericDialogPlus dialogParams = new GenericDialogPlus("Processing");
                dialogParams.addMessage("Your process is already running!");
                dialogParams.showDialog();
            } else {
                boolean isConnectedDag;
                boolean isDag;
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                mxGraph graph = graphComponent.getGraph();
                boolean isInvalidated = false;
                String errorMsg = "Unknown";
                mxAnalysisGraph aGraph = new mxAnalysisGraph();
                aGraph.setGraph(graph);
                mxGraphProperties.setDirected((Map)aGraph.getProperties(), (boolean)true);
                boolean isConnected = mxGraphStructure.isConnected((mxAnalysisGraph)aGraph);
                if (!isConnected) {
                    errorMsg = "Graph not connected";
                }
                boolean bl = isDag = !mxGraphStructure.isCyclicDirected((mxAnalysisGraph)aGraph);
                if (!isDag) {
                    errorMsg = "Graph not a DAG";
                }
                boolean bl2 = isConnectedDag = isConnected && isDag;
                if (!isConnectedDag) {
                    isInvalidated = true;
                } else {
                    Operation op;
                    mxCell[] nodes;
                    Operation op2;
                    try {
                        mxCell[] sources;
                        boolean areSourcesValid = true;
                        for (mxCell source : sources = (mxCell[])Arrays.stream(mxGraphStructure.getSourceVertices((mxAnalysisGraph)aGraph)).toArray(mxCell[]::new)) {
                            op2 = (Operation)source.getValue();
                            if (op2.getType() == OpType.INPUT) continue;
                            errorMsg = "A source is not an input";
                            areSourcesValid = false;
                            break;
                        }
                        graph.selectCells(true, false);
                        nodes = (mxCell[])Arrays.stream(graph.getSelectionCells()).toArray(mxCell[]::new);
                        graph.selectCells(false, false);
                        mxCell[] mxCellArray = nodes;
                        int n = mxCellArray.length;
                        for (int source = 0; source < n; ++source) {
                            mxCell node = mxCellArray[source];
                            op = (Operation)node.getValue();
                            if (op.getType() == OpType.INPUT && graph.getIncomingEdges((Object)node).length > 0) {
                                errorMsg = "An input is not a source";
                                areSourcesValid = false;
                                break;
                            }
                            if (op.isValid()) continue;
                            errorMsg = String.format("Node <%s, %s> is not valid", new Object[]{op.getName(), op.getType()});
                            isInvalidated = true;
                            break;
                        }
                        if (!areSourcesValid) {
                            isInvalidated = true;
                        }
                    }
                    catch (StructuralException e1) {
                        isInvalidated = true;
                        e1.printStackTrace();
                    }
                    try {
                        mxCell[] sinks;
                        boolean areSinksValid = true;
                        for (mxCell sink : sinks = (mxCell[])Arrays.stream(mxGraphStructure.getSinkVertices((mxAnalysisGraph)aGraph)).toArray(mxCell[]::new)) {
                            op2 = (Operation)sink.getValue();
                            if (op2.getType() == OpType.OUTPUT) continue;
                            errorMsg = "A sink is not an output";
                            areSinksValid = false;
                            break;
                        }
                        graph.selectCells(true, false);
                        nodes = (mxCell[])Arrays.stream(graph.getSelectionCells()).toArray(mxCell[]::new);
                        graph.selectCells(false, false);
                        for (mxCell node : nodes) {
                            op = (Operation)node.getValue();
                            if (op.getType() != OpType.OUTPUT) continue;
                            if (graph.getOutgoingEdges((Object)node).length > 0) {
                                errorMsg = "An output is not a sink";
                                areSinksValid = false;
                                break;
                            }
                            if (graph.getIncomingEdges((Object)node).length <= 1) continue;
                            errorMsg = "An output must have one parent";
                            areSinksValid = false;
                            break;
                        }
                        if (!areSinksValid) {
                            isInvalidated = true;
                        }
                    }
                    catch (StructuralException e1) {
                        isInvalidated = true;
                        e1.printStackTrace();
                    }
                }
                if (!isInvalidated) {
                    GenericDialogPlus dialogParams = new GenericDialogPlus("Graph Validation");
                    dialogParams.addMessage("Your graph is valid!\nPress OK to begin processing.");
                    dialogParams.showDialog();
                    System.out.println("Graph is valid!");
                    AlgorithmFlowEditor.core.getThread().run(() -> {
                        AlgorithmGraph algoGraph = new AlgorithmGraph(graph);
                        GraphProcessor processor = new GraphProcessor(AlgorithmFlowEditor.core, algoGraph);
                    });
                    AlgorithmFlowEditor.core.getUi().getDefaultUI().getConsolePane();
                } else {
                    GenericDialogPlus dialogParams = new GenericDialogPlus("Graph Validation");
                    dialogParams.addMessage("Sorry, your graph is invalid!\nReason: " + errorMsg);
                    dialogParams.showDialog();
                    System.out.println("Graph is invalid!");
                }
            }
        }
    }

    public static class PropertiesAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
            mxGraph graph = graphComponent.getGraph();
            mxCell cell = (mxCell)graph.getSelectionCell();
            PropertiesDialog dialog = PropertiesDialogFactory.getDialog(cell, graph);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension frameSize = dialog.getSize();
            dialog.setLocation(screenSize.width / 2 - frameSize.width / 2, screenSize.height / 2 - frameSize.height / 2);
        }
    }

    public static class StyleAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            mxGraph graph;
            String initial;
            mxGraphComponent graphComponent;
            String value;
            if (e.getSource() instanceof mxGraphComponent && (value = (String)JOptionPane.showInputDialog((Component)(graphComponent = (mxGraphComponent)e.getSource()), "Style", "Style", -1, null, null, initial = (graph = graphComponent.getGraph()).getModel().getStyle(graph.getSelectionCell()))) != null) {
                graph.setCellStyle(value);
            }
        }
    }

    public static class BackgroundAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof mxGraphComponent) {
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                Color newColor = JColorChooser.showDialog((Component)graphComponent, "Background", null);
                if (newColor != null) {
                    graphComponent.getViewport().setOpaque(true);
                    graphComponent.getViewport().setBackground(newColor);
                }
                graphComponent.getGraph().repaint();
            }
        }
    }

    public static class ColorAction
    extends AbstractAction {
        protected String name;
        protected String key;

        public ColorAction(String name, String key) {
            this.name = name;
            this.key = key;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Color newColor;
            mxGraphComponent graphComponent;
            mxGraph graph;
            if (e.getSource() instanceof mxGraphComponent && !(graph = (graphComponent = (mxGraphComponent)e.getSource()).getGraph()).isSelectionEmpty() && (newColor = JColorChooser.showDialog((Component)graphComponent, this.name, null)) != null) {
                graph.setCellStyles(this.key, mxUtils.hexString((Color)newColor));
            }
        }
    }

    public static class AutosizeAction
    extends AbstractAction {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            mxGraph graph = mxGraphActions.getGraph((ActionEvent)e);
            if (graph != null && !graph.isSelectionEmpty()) {
                Object[] cells = graph.getSelectionCells();
                mxIGraphModel model = graph.getModel();
                model.beginUpdate();
                try {
                    for (int i = 0; i < cells.length; ++i) {
                        graph.updateCellSize(cells[i]);
                    }
                }
                finally {
                    model.endUpdate();
                }
            }
        }
    }

    public static class AlignCellsAction
    extends AbstractAction {
        protected String align;

        public AlignCellsAction(String align) {
            this.align = align;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            mxGraph graph = mxGraphActions.getGraph((ActionEvent)e);
            if (graph != null && !graph.isSelectionEmpty()) {
                graph.alignCells(this.align);
            }
        }
    }

    public static class PromptValueAction
    extends AbstractAction {
        protected String key;
        protected String message;

        public PromptValueAction(String key, String message) {
            this.key = key;
            this.message = message;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String value;
            mxGraph graph;
            if (e.getSource() instanceof Component && (graph = mxGraphActions.getGraph((ActionEvent)e)) != null && !graph.isSelectionEmpty() && (value = (String)JOptionPane.showInputDialog((Component)e.getSource(), "Value", this.message, -1, null, null, "")) != null) {
                if (value.equals(mxConstants.NONE)) {
                    value = null;
                }
                graph.setCellStyles(this.key, value);
            }
        }
    }

    public static class KeyValueAction
    extends AbstractAction {
        protected String key;
        protected String value;

        public KeyValueAction(String key) {
            this(key, (String)null);
        }

        public KeyValueAction(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            mxGraph graph = mxGraphActions.getGraph((ActionEvent)e);
            if (graph != null && !graph.isSelectionEmpty()) {
                graph.setCellStyles(this.key, this.value);
            }
        }
    }

    public static class ToggleAction
    extends AbstractAction {
        protected String key;
        protected boolean defaultValue;

        public ToggleAction(String key) {
            this(key, false);
        }

        public ToggleAction(String key, boolean defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            mxGraph graph = mxGraphActions.getGraph((ActionEvent)e);
            if (graph != null) {
                graph.toggleCellStyles(this.key, this.defaultValue);
            }
        }
    }

    public static class OpenAction
    extends AbstractAction {
        protected String lastDir;

        protected void resetEditor(GraphEditor editor) {
            editor.setModified(false);
            editor.getUndoManager().clear();
            editor.getGraphComponent().zoomAndCenter();
        }

        protected void openXmlPng(GraphEditor editor, File file) throws IOException {
            String value;
            Map text = mxPngTextDecoder.decodeCompressedText((InputStream)new FileInputStream(file));
            if (text != null && (value = (String)text.get("mxGraphModel")) != null) {
                Document document = mxXmlUtils.parseXml((String)URLDecoder.decode(value, "UTF-8"));
                mxCodec codec = new mxCodec(document);
                codec.decode((Node)document.getDocumentElement(), (Object)editor.getGraphComponent().getGraph().getModel());
                editor.setCurrentFile(file);
                this.resetEditor(editor);
                return;
            }
            JOptionPane.showMessageDialog(editor, "Image contains no diagram data");
        }

        protected void openGD(GraphEditor editor, File file, String gdText) {
            mxGraph graph = editor.getGraphComponent().getGraph();
            String filename = file.getName();
            if (new File(filename = filename.substring(0, filename.length() - 4) + ".mxe").exists() && JOptionPane.showConfirmDialog(editor, "Overwrite existing file?") != 0) {
                return;
            }
            ((mxGraphModel)graph.getModel()).clear();
            mxGdCodec.decode((String)gdText, (mxGraph)graph);
            editor.getGraphComponent().zoomAndCenter();
            editor.setCurrentFile(new File(this.lastDir + "/" + filename));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            mxGraph graph;
            GraphEditor editor = Actions.getEditor(e);
            if (editor != null && (editor.isNotModified() || JOptionPane.showConfirmDialog(editor, "Lose changes?") == 0) && (graph = editor.getGraphComponent().getGraph()) != null) {
                String wd = this.lastDir != null ? this.lastDir : System.getProperty("user.dir");
                JFileChooser fc = new JFileChooser(wd);
                DefaultFileFilter defaultFilter = new DefaultFileFilter(".mxe", "All supported formats (.mxe, .png, .vdx)"){

                    @Override
                    public boolean accept(File file) {
                        String lcase = file.getName().toLowerCase();
                        return super.accept(file) || lcase.endsWith(".png") || lcase.endsWith(".vdx");
                    }
                };
                fc.addChoosableFileFilter(defaultFilter);
                fc.addChoosableFileFilter(new DefaultFileFilter(".mxe", "mxGraph Editor File (.mxe)"));
                fc.addChoosableFileFilter(new DefaultFileFilter(".png", "PNG+XML  File (.png)"));
                fc.addChoosableFileFilter(new DefaultFileFilter(".vdx", "XML Drawing  File (.vdx)"));
                fc.addChoosableFileFilter(new DefaultFileFilter(".txt", "Graph Drawing  File (.txt)"));
                fc.setFileFilter(defaultFilter);
                int rc = fc.showDialog(null, "Open file");
                if (rc == 0) {
                    this.lastDir = fc.getSelectedFile().getParent();
                    try {
                        if (fc.getSelectedFile().getAbsolutePath().toLowerCase().endsWith(".png")) {
                            this.openXmlPng(editor, fc.getSelectedFile());
                        } else if (fc.getSelectedFile().getAbsolutePath().toLowerCase().endsWith(".txt")) {
                            this.openGD(editor, fc.getSelectedFile(), mxUtils.readFile((String)fc.getSelectedFile().getAbsolutePath()));
                        } else {
                            Document document = mxXmlUtils.parseXml((String)mxUtils.readFile((String)fc.getSelectedFile().getAbsolutePath()));
                            mxCodec codec = new mxCodec(document);
                            codec.decode((Node)document.getDocumentElement(), (Object)graph.getModel());
                            editor.setCurrentFile(fc.getSelectedFile());
                            this.resetEditor(editor);
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog((Component)editor.getGraphComponent(), ex.toString(), "Error", 0);
                    }
                }
            }
        }
    }

    public static class NewAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            GraphEditor editor = Actions.getEditor(e);
            if (editor != null && (editor.isNotModified() || JOptionPane.showConfirmDialog(editor, "Lose changes?") == 0)) {
                mxGraph graph = editor.getGraphComponent().getGraph();
                mxCell root = new mxCell();
                root.insert((mxICell)new mxCell());
                graph.getModel().setRoot((Object)root);
                editor.setModified(false);
                editor.setCurrentFile(null);
                editor.getGraphComponent().zoomAndCenter();
            }
        }
    }

    public static class HistoryAction
    extends AbstractAction {
        protected boolean undo;

        public HistoryAction(boolean undo) {
            this.undo = undo;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphEditor editor = Actions.getEditor(e);
            if (editor != null) {
                if (this.undo) {
                    editor.getUndoManager().undo();
                } else {
                    editor.getUndoManager().redo();
                }
            }
        }
    }

    public static class TogglePropertyItem
    extends JCheckBoxMenuItem {
        public TogglePropertyItem(Object target, String name, String fieldname) {
            this(target, name, fieldname, false);
        }

        public TogglePropertyItem(Object target, String name, String fieldname, boolean refresh) {
            this(target, name, fieldname, refresh, null);
        }

        public TogglePropertyItem(Object target, String name, String fieldname, boolean refresh, ActionListener listener) {
            super(name);
            if (listener != null) {
                this.addActionListener(listener);
            }
            this.addActionListener(e -> this.execute(target, fieldname, refresh));
            PropertyChangeListener propertyChangeListener = evt -> {
                if (evt.getPropertyName().equalsIgnoreCase(fieldname)) {
                    this.update(target, fieldname);
                }
            };
            if (target instanceof mxGraphComponent) {
                ((mxGraphComponent)target).addPropertyChangeListener(propertyChangeListener);
            } else if (target instanceof mxGraph) {
                ((mxGraph)target).addPropertyChangeListener(propertyChangeListener);
            }
            this.update(target, fieldname);
        }

        public void update(Object target, String fieldname) {
            if (target != null && fieldname != null) {
                try {
                    Object current;
                    Method getter = target.getClass().getMethod("is" + fieldname, new Class[0]);
                    if (getter != null && (current = getter.invoke(target, new Object[0])) instanceof Boolean) {
                        this.setSelected((Boolean)current);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void execute(Object target, String fieldname, boolean refresh) {
            if (target != null && fieldname != null) {
                try {
                    Method getter = target.getClass().getMethod("is" + fieldname, new Class[0]);
                    Method setter = target.getClass().getMethod("set" + fieldname, Boolean.TYPE);
                    Object current = getter.invoke(target, new Object[0]);
                    if (current instanceof Boolean) {
                        boolean value = (Boolean)current == false;
                        setter.invoke(target, value);
                        this.setSelected(value);
                    }
                    if (refresh) {
                        mxGraph graph = null;
                        if (target instanceof mxGraph) {
                            graph = (mxGraph)target;
                        } else if (target instanceof mxGraphComponent) {
                            graph = ((mxGraphComponent)target).getGraph();
                        }
                        graph.refresh();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static class PromptPropertyAction
    extends AbstractAction {
        protected Object target;
        protected String fieldname;
        protected String message;

        public PromptPropertyAction(Object target, String message) {
            this(target, message, message);
        }

        public PromptPropertyAction(Object target, String message, String fieldname) {
            this.target = target;
            this.message = message;
            this.fieldname = fieldname;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof Component) {
                try {
                    Method getter = this.target.getClass().getMethod("get" + this.fieldname, new Class[0]);
                    Object current = getter.invoke(this.target, new Object[0]);
                    if (current instanceof Integer) {
                        Method setter = this.target.getClass().getMethod("set" + this.fieldname, Integer.TYPE);
                        String value = (String)JOptionPane.showInputDialog((Component)e.getSource(), "Value", this.message, -1, null, null, current);
                        if (value != null) {
                            setter.invoke(this.target, Integer.parseInt(value));
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (e.getSource() instanceof mxGraphComponent) {
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                graphComponent.repaint();
            }
        }
    }

    public static class ToggleCreateTargetItem
    extends JCheckBoxMenuItem {
        public ToggleCreateTargetItem(GraphEditor editor, String name) {
            super(name);
            this.setSelected(true);
            this.addActionListener(e -> {
                mxGraphComponent graphComponent = editor.getGraphComponent();
                if (graphComponent != null) {
                    mxConnectionHandler handler;
                    handler.setCreateTarget(!(handler = graphComponent.getConnectionHandler()).isCreateTarget());
                    this.setSelected(handler.isCreateTarget());
                }
            });
        }
    }

    public static class ToggleConnectModeAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof mxGraphComponent) {
                mxConnectionHandler handler;
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                handler.setHandleEnabled(!(handler = graphComponent.getConnectionHandler()).isHandleEnabled());
            }
        }
    }

    public static class ToggleDirtyAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof mxGraphComponent) {
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                graphComponent.showDirtyRectangle = !graphComponent.showDirtyRectangle;
            }
        }
    }

    public static class SaveAction
    extends AbstractAction {
        protected boolean showDialog;
        protected String lastDir = null;

        public SaveAction(boolean showDialog) {
            this.showDialog = showDialog;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void saveXmlPng(GraphEditor editor, String filename, Color bg) throws IOException {
            mxGraphComponent graphComponent = editor.getGraphComponent();
            mxGraph graph = graphComponent.getGraph();
            BufferedImage image = mxCellRenderer.createBufferedImage((mxGraph)graph, null, (double)1.0, (Color)bg, (boolean)graphComponent.isAntiAlias(), null, (mxGraphics2DCanvas)graphComponent.getCanvas());
            mxCodec codec = new mxCodec();
            String xml = URLEncoder.encode(mxXmlUtils.getXml((Node)codec.encode((Object)graph.getModel())), "UTF-8");
            mxPngEncodeParam param = mxPngEncodeParam.getDefaultEncodeParam((RenderedImage)image);
            param.setCompressedText(new String[]{"mxGraphModel", xml});
            try (FileOutputStream outputStream = new FileOutputStream(new File(filename));){
                mxPngImageEncoder encoder = new mxPngImageEncoder((OutputStream)outputStream, param);
                if (image != null) {
                    encoder.encode((RenderedImage)image);
                    editor.setModified(false);
                    editor.setCurrentFile(new File(filename));
                } else {
                    JOptionPane.showMessageDialog((Component)graphComponent, "No Image Data");
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphEditor editor = Actions.getEditor(e);
            if (editor != null) {
                mxGraphComponent graphComponent = editor.getGraphComponent();
                mxGraph graph = graphComponent.getGraph();
                FileFilter selectedFilter = null;
                DefaultFileFilter xmlPngFilter = new DefaultFileFilter(".png", "PNG+XML File (.png)");
                DefaultFileFilter vmlFileFilter = new DefaultFileFilter(".html", "VML File (.html)");
                String filename = null;
                boolean dialogShown = false;
                if (this.showDialog || editor.getCurrentFile() == null) {
                    String ext;
                    int i;
                    String wd = this.lastDir != null ? this.lastDir : (editor.getCurrentFile() != null ? editor.getCurrentFile().getParent() : System.getProperty("user.dir"));
                    JFileChooser fc = new JFileChooser(wd);
                    fc.addChoosableFileFilter(xmlPngFilter);
                    fc.addChoosableFileFilter(new DefaultFileFilter(".mxe", "mxGraph Editor File (.mxe)"));
                    fc.addChoosableFileFilter(new DefaultFileFilter(".txt", "Graph Drawing File (.txt)"));
                    fc.addChoosableFileFilter(new DefaultFileFilter(".svg", "SVG File (.svg)"));
                    fc.addChoosableFileFilter(vmlFileFilter);
                    fc.addChoosableFileFilter(new DefaultFileFilter(".html", "HTML File (.html)"));
                    Object[] imageFormats = ImageIO.getReaderFormatNames();
                    HashSet<String> formats = new HashSet<String>();
                    for (i = 0; i < imageFormats.length; ++i) {
                        ext = imageFormats[i].toString().toLowerCase();
                        formats.add(ext);
                    }
                    imageFormats = formats.toArray();
                    for (i = 0; i < imageFormats.length; ++i) {
                        ext = imageFormats[i].toString();
                        fc.addChoosableFileFilter(new DefaultFileFilter("." + ext, ext.toUpperCase() + " File (." + ext + ")"));
                    }
                    fc.addChoosableFileFilter(new DefaultFileFilter.ImageFileFilter("All Images"));
                    fc.setFileFilter(xmlPngFilter);
                    int rc = fc.showDialog(null, "Save");
                    dialogShown = true;
                    if (rc != 0) {
                        return;
                    }
                    this.lastDir = fc.getSelectedFile().getParent();
                    filename = fc.getSelectedFile().getAbsolutePath();
                    selectedFilter = fc.getFileFilter();
                    if (selectedFilter instanceof DefaultFileFilter) {
                        ext = ((DefaultFileFilter)selectedFilter).getExtension();
                        if (!filename.toLowerCase().endsWith(ext)) {
                            filename = filename + ext;
                        }
                    }
                    if (new File(filename).exists() && JOptionPane.showConfirmDialog((Component)graphComponent, "Overwrite existing file") != 0) {
                        return;
                    }
                } else {
                    filename = editor.getCurrentFile().getAbsolutePath();
                }
                try {
                    String ext = filename.substring(filename.lastIndexOf(46) + 1);
                    if (ext.equalsIgnoreCase("svg")) {
                        mxSvgCanvas canvas = (mxSvgCanvas)mxCellRenderer.drawCells((mxGraph)graph, null, (double)1.0, null, (mxCellRenderer.CanvasFactory)new mxCellRenderer.CanvasFactory(){

                            public mxICanvas createCanvas(int width, int height) {
                                mxSvgCanvas canvas = new mxSvgCanvas(mxDomUtils.createSvgDocument((int)width, (int)height));
                                canvas.setEmbedded(true);
                                return canvas;
                            }
                        });
                        mxUtils.writeFile((String)mxXmlUtils.getXml((Node)canvas.getDocument()), (String)filename);
                    } else if (selectedFilter == vmlFileFilter) {
                        mxUtils.writeFile((String)mxXmlUtils.getXml((Node)mxCellRenderer.createVmlDocument((mxGraph)graph, null, (double)1.0, null, null).getDocumentElement()), (String)filename);
                    } else if (ext.equalsIgnoreCase("html")) {
                        mxUtils.writeFile((String)mxXmlUtils.getXml((Node)mxCellRenderer.createHtmlDocument((mxGraph)graph, null, (double)1.0, null, null).getDocumentElement()), (String)filename);
                    } else if (ext.equalsIgnoreCase("mxe") || ext.equalsIgnoreCase("xml")) {
                        mxCodec codec = new mxCodec();
                        String xml = mxXmlUtils.getXml((Node)codec.encode((Object)graph.getModel()));
                        mxUtils.writeFile((String)xml, (String)filename);
                        editor.setModified(false);
                        editor.setCurrentFile(new File(filename));
                    } else if (ext.equalsIgnoreCase("txt")) {
                        String content = mxGdCodec.encode((mxGraph)graph);
                        mxUtils.writeFile((String)content, (String)filename);
                    } else {
                        Color bg = null;
                        if (!ext.equalsIgnoreCase("gif") && !ext.equalsIgnoreCase("png") || JOptionPane.showConfirmDialog((Component)graphComponent, mxResources.get((String)"transparentBackground")) != 0) {
                            bg = graphComponent.getBackground();
                        }
                        if (selectedFilter == xmlPngFilter || editor.getCurrentFile() != null && ext.equalsIgnoreCase("png") && !dialogShown) {
                            this.saveXmlPng(editor, filename, bg);
                        } else {
                            BufferedImage image = mxCellRenderer.createBufferedImage((mxGraph)graph, null, (double)1.0, (Color)bg, (boolean)graphComponent.isAntiAlias(), null, (mxGraphics2DCanvas)graphComponent.getCanvas());
                            if (image != null) {
                                ImageIO.write((RenderedImage)image, ext, new File(filename));
                            } else {
                                JOptionPane.showMessageDialog((Component)graphComponent, "No Image Data");
                            }
                        }
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog((Component)graphComponent, ex.toString(), "Error", 0);
                }
            }
        }
    }

    public static class ScaleAction
    extends AbstractAction {
        protected double scale;

        public ScaleAction(double scale) {
            this.scale = scale;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof mxGraphComponent) {
                String value;
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                double scale = this.scale;
                if (scale == 0.0 && (value = (String)JOptionPane.showInputDialog((Component)graphComponent, "Value", "Scale (%)", -1, null, null, "")) != null) {
                    scale = Double.parseDouble(value.replace("%", "")) / 100.0;
                }
                if (scale > 0.0) {
                    graphComponent.zoomTo(scale, graphComponent.isCenterZoom());
                }
            }
        }
    }

    public static class ZoomPolicyAction
    extends AbstractAction {
        protected int zoomPolicy;

        public ZoomPolicyAction(int zoomPolicy) {
            this.zoomPolicy = zoomPolicy;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof mxGraphComponent) {
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                graphComponent.setPageVisible(true);
                graphComponent.setZoomPolicy(this.zoomPolicy);
            }
        }
    }

    public static class StylesheetAction
    extends AbstractAction {
        protected String stylesheet;

        public StylesheetAction(String stylesheet) {
            this.stylesheet = stylesheet;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof mxGraphComponent) {
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                mxGraph graph = graphComponent.getGraph();
                mxCodec codec = new mxCodec();
                Document doc = mxUtils.loadDocument((String)Actions.class.getResource(this.stylesheet).toString());
                if (doc != null) {
                    codec.decode((Node)doc.getDocumentElement(), (Object)graph.getStylesheet());
                    graph.refresh();
                }
            }
        }
    }

    public static class ExitAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            GraphEditor editor = Actions.getEditor(e);
            if (editor != null) {
                editor.exit();
            }
        }
    }

    public static class ToggleGridItem
    extends JCheckBoxMenuItem {
        public ToggleGridItem(GraphEditor editor, String name) {
            super(name);
            this.setSelected(true);
            this.addActionListener(e -> {
                mxGraphComponent graphComponent = editor.getGraphComponent();
                mxGraph graph = graphComponent.getGraph();
                boolean enabled = !graph.isGridEnabled();
                graph.setGridEnabled(enabled);
                graphComponent.setGridVisible(enabled);
                graphComponent.repaint();
                this.setSelected(enabled);
            });
        }
    }
}

