/*
 * Decompiled with CFR 0.152.
 */
package graphs.editor;

import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxGraphActions;
import com.mxgraph.util.mxPoint;
import com.mxgraph.view.mxGraph;
import graphs.editor.Actions;
import graphs.editor.GraphEditor;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;

public class MenuBar
extends JMenuBar {
    private static final long serialVersionUID = 4060203894740766714L;

    public MenuBar(GraphEditor editor) {
        mxGraphComponent graphComponent = editor.getGraphComponent();
        mxGraph graph = graphComponent.getGraph();
        JMenu menu = this.add(new JMenu("File"));
        menu.add(editor.bind("New", new Actions.NewAction()));
        menu.add(editor.bind("Open", new Actions.OpenAction()));
        menu.addSeparator();
        menu.add(editor.bind("Save", new Actions.SaveAction(false)));
        menu.add(editor.bind("Save as...", new Actions.SaveAction(true)));
        menu.addSeparator();
        menu.add(editor.bind("Terminate", new Actions.ExitAction()));
        menu = this.add(new JMenu("Edit"));
        menu.add(editor.bind("Undo", new Actions.HistoryAction(true)));
        menu.add(editor.bind("Redo", new Actions.HistoryAction(false)));
        menu.addSeparator();
        menu.add(editor.bind("Cut", TransferHandler.getCutAction()));
        menu.add(editor.bind("Copy", TransferHandler.getCopyAction()));
        menu.add(editor.bind("Paste", TransferHandler.getPasteAction()));
        menu.addSeparator();
        menu.add(editor.bind("Delete", mxGraphActions.getDeleteAction()));
        menu.addSeparator();
        menu.add(editor.bind("Select all", mxGraphActions.getSelectAllAction()));
        menu.add(editor.bind("Deselect", mxGraphActions.getSelectNoneAction()));
        menu = this.add(new JMenu("View"));
        JMenuItem item = menu.add(new Actions.TogglePropertyItem(graphComponent, "Page Visible", "PageVisible", true, e -> {
            if (graphComponent.isPageVisible() && graphComponent.isCenterPage()) {
                graphComponent.zoomAndCenter();
            } else {
                graphComponent.getGraphControl().updatePreferredSize();
            }
        }));
        item.addActionListener(e -> {
            if (e.getSource() instanceof Actions.TogglePropertyItem) {
                mxGraphComponent graphComponent1 = editor.getGraphComponent();
                Actions.TogglePropertyItem toggleItem = (Actions.TogglePropertyItem)e.getSource();
                if (toggleItem.isSelected()) {
                    SwingUtilities.invokeLater(() -> {
                        graphComponent1.scrollToCenter(true);
                        graphComponent1.scrollToCenter(false);
                    });
                } else {
                    mxPoint tr = graphComponent1.getGraph().getView().getTranslate();
                    if (tr.getX() != 0.0 || tr.getY() != 0.0) {
                        graphComponent1.getGraph().getView().setTranslate(new mxPoint());
                    }
                }
            }
        });
        menu.addSeparator();
        menu.add(new Actions.ToggleGridItem(editor, "Grid"));
        menu.addSeparator();
        JMenu submenu = (JMenu)menu.add(new JMenu("Zoom"));
        submenu.add(editor.bind("400%", new Actions.ScaleAction(4.0)));
        submenu.add(editor.bind("200%", new Actions.ScaleAction(2.0)));
        submenu.add(editor.bind("150%", new Actions.ScaleAction(1.5)));
        submenu.add(editor.bind("100%", new Actions.ScaleAction(1.0)));
        submenu.add(editor.bind("75%", new Actions.ScaleAction(0.75)));
        submenu.add(editor.bind("50%", new Actions.ScaleAction(0.5)));
        submenu.addSeparator();
        submenu.add(editor.bind("Custom Scale...", new Actions.ScaleAction(0.0)));
        menu.addSeparator();
        menu.add(editor.bind("Zoom in", mxGraphActions.getZoomInAction()));
        menu.add(editor.bind("Zoom out", mxGraphActions.getZoomOutAction()));
        menu.addSeparator();
        menu.add(editor.bind("Fit page", new Actions.ZoomPolicyAction(1)));
        menu.add(editor.bind("Fit width", new Actions.ZoomPolicyAction(2)));
        menu.addSeparator();
        menu.add(editor.bind("Actual size", mxGraphActions.getZoomActualAction()));
        menu = this.add(new JMenu("Layout"));
        menu.add(editor.graphLayout("Beautify (Vertical)", true));
        menu.add(editor.graphLayout("Beautify (Horizontal)", true));
    }
}

