/*
 * Decompiled with CFR 0.152.
 */
package graphs.editor;

import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxGraphActions;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.view.mxGraphView;
import graphs.editor.Actions;
import graphs.editor.GraphEditor;
import java.awt.Dimension;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.TransferHandler;

public class ToolBar
extends JToolBar {
    private static final long serialVersionUID = -8015443128436394471L;
    private boolean ignoreZoomChange = false;

    public ToolBar(GraphEditor editor, int orientation) {
        super(orientation);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), this.getBorder()));
        this.setFloatable(false);
        this.add(editor.bind("New", new Actions.NewAction()));
        this.add(editor.bind("Open", new Actions.OpenAction()));
        this.add(editor.bind("Save", new Actions.SaveAction(false)));
        this.addSeparator();
        this.add(editor.bind("Cut", TransferHandler.getCutAction()));
        this.add(editor.bind("Copy", TransferHandler.getCopyAction()));
        this.add(editor.bind("Paste", TransferHandler.getPasteAction()));
        this.addSeparator();
        this.add(editor.bind("Delete", mxGraphActions.getDeleteAction()));
        this.addSeparator();
        this.add(editor.bind("Undo", new Actions.HistoryAction(true)));
        this.add(editor.bind("Redo", new Actions.HistoryAction(false)));
        this.addSeparator();
        mxGraphView view = editor.getGraphComponent().getGraph().getView();
        JComboBox<String> zoomCombo = new JComboBox<String>(new String[]{"400%", "200%", "150%", "100%", "75%", "50%", "Page", "Width", "Actual size"});
        zoomCombo.setEditable(true);
        zoomCombo.setMinimumSize(new Dimension(75, 0));
        zoomCombo.setPreferredSize(new Dimension(75, 0));
        zoomCombo.setMaximumSize(new Dimension(75, 100));
        zoomCombo.setMaximumRowCount(9);
        this.add(zoomCombo);
        this.addSeparator();
        this.add(editor.bind("RUN", new Actions.ValidateGraphAction()));
        mxEventSource.mxIEventListener scaleTracker = (sender, evt) -> {
            this.ignoreZoomChange = true;
            try {
                zoomCombo.setSelectedItem((int)Math.round(100.0 * view.getScale()) + "%");
            }
            finally {
                this.ignoreZoomChange = false;
            }
        };
        view.getGraph().getView().addListener("scale", scaleTracker);
        view.getGraph().getView().addListener("scaleAndTranslate", scaleTracker);
        scaleTracker.invoke(null, null);
        zoomCombo.addActionListener(e -> {
            mxGraphComponent graphComponent = editor.getGraphComponent();
            if (!this.ignoreZoomChange) {
                String zoom;
                switch (zoom = Objects.requireNonNull(zoomCombo.getSelectedItem()).toString()) {
                    case "Page": {
                        graphComponent.setPageVisible(true);
                        graphComponent.setZoomPolicy(1);
                        break;
                    }
                    case "Width": {
                        graphComponent.setPageVisible(true);
                        graphComponent.setZoomPolicy(2);
                        break;
                    }
                    case "Actual size": {
                        graphComponent.zoomActual();
                        break;
                    }
                    default: {
                        try {
                            zoom = zoom.replace("%", "");
                            double scale = Math.min(16.0, Math.max(0.01, Double.parseDouble(zoom) / 100.0));
                            graphComponent.zoomTo(scale, graphComponent.isCenterZoom());
                            break;
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(editor, ex.getMessage());
                        }
                    }
                }
            }
        });
    }
}

