/*
 * Decompiled with CFR 0.152.
 */
package graphs.model;

import graphs.model.OpType;
import graphs.model.Operation;
import java.util.Map;

public class TopHatOp
extends Operation {
    private ThType thType;
    private Shape shape;
    private Integer radius;

    public TopHatOp(ThType thType, Shape shape, Integer radius) {
        super("Top-Hat", OpType.TOPHAT);
        this.thType = thType;
        this.shape = shape;
        this.radius = radius;
    }

    public TopHatOp() {
        super("Top-Hat", OpType.TOPHAT);
        this.thType = ThType.WHITE;
        this.shape = Shape.DISK;
        this.radius = 6;
    }

    public ThType getThType() {
        return this.thType;
    }

    public void setThType(ThType thType) {
        this.thType = thType;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public Integer getRadius() {
        return this.radius;
    }

    public void setRadius(Integer radius) {
        this.radius = radius;
    }

    @Override
    public Map<String, String> getKeyValuePairs() {
        Map<String, String> map = super.getKeyValuePairs();
        map.put("thType", this.thType.toString());
        map.put("shape", this.shape.toString());
        map.put("radius", String.valueOf(this.radius));
        return map;
    }

    @Override
    public String toString() {
        return String.format("%s\ntype = %s\nshape = %s\nradius = %s", super.toString(), this.thType.toString(), this.shape.toString(), this.radius);
    }

    public static enum Shape {
        DISK,
        DIAMOND,
        SQUARE;

    }

    public static enum ThType {
        BLACK,
        WHITE;

    }
}

